/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.TabCompletable;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.Username;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.User;

public class TpCommand
extends Command
implements TabCompletable {
    protected TpCommand(@NotNull HuskHomes plugin) {
        super(List.of("tp", "tpo"), "[<player|position>] [target]", plugin);
        this.addAdditionalPermissions(Map.of("coordinates", true, "other", true));
        this.setOperatorCommand(true);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        switch (args.length) {
            case 1: {
                if (!(executor instanceof OnlineUser)) {
                    this.plugin.getLocales().getLocale("error_in_game_only").ifPresent(executor::sendMessage);
                    return;
                }
                OnlineUser user = (OnlineUser)executor;
                this.execute(executor, user, Target.username(args[0]), args);
                break;
            }
            case 2: {
                this.execute(executor, Teleportable.username(args[0]), Target.username(args[1]), args);
                break;
            }
            default: {
                Optional target;
                Position basePosition = this.getBasePosition(executor);
                Optional<Object> optional = target = executor.hasPermission(this.getPermission("coordinates")) ? this.parsePositionArgs(basePosition, args, 0) : Optional.empty();
                if (target.isPresent()) {
                    if (!(executor instanceof OnlineUser)) {
                        this.plugin.getLocales().getLocale("error_in_game_only").ifPresent(executor::sendMessage);
                        return;
                    }
                    OnlineUser user = (OnlineUser)executor;
                    this.execute(executor, user, (Target)target.get(), args);
                    return;
                }
                Optional<Object> optional2 = target = executor.hasPermission(this.getPermission("coordinates")) ? this.parsePositionArgs(basePosition, args, 1) : Optional.empty();
                if (target.isPresent() && args.length >= 1) {
                    this.execute(executor, Teleportable.username(args[0]), (Target)target.get(), args);
                    return;
                }
                this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            }
        }
    }

    private void execute(@NotNull CommandUser executor, @NotNull Teleportable teleporter, @NotNull Target target, @NotNull String[] args) {
        String targetName;
        OnlineUser online;
        TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(teleporter).target(target);
        if (target instanceof Username) {
            Username username = (Username)target;
            v0 = username.name();
        } else if (target instanceof OnlineUser) {
            online = (OnlineUser)((Object)target);
            v0 = online.getName();
        } else {
            v0 = targetName = null;
        }
        if (executor instanceof OnlineUser) {
            online = (OnlineUser)executor;
            if (online.equals(teleporter)) {
                if (teleporter.getName().equalsIgnoreCase(targetName)) {
                    this.plugin.getLocales().getLocale("error_cannot_teleport_self").ifPresent(executor::sendMessage);
                    return;
                }
            } else if (!executor.hasPermission(this.getPermission("other"))) {
                this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
                return;
            }
            builder.executor(online);
        }
        if (!builder.buildAndComplete(false, args)) {
            return;
        }
        if (target instanceof Position) {
            Position position = (Position)target;
            this.plugin.getLocales().getLocale("teleporting_other_complete_position", teleporter.getName(), Integer.toString((int)position.getX()), Integer.toString((int)position.getY()), Integer.toString((int)position.getZ())).ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.getLocales().getLocale("teleporting_other_complete", teleporter.getName(), Objects.requireNonNull(targetName)).ifPresent(executor::sendMessage);
    }

    @Override
    @NotNull
    public final List<String> suggest(@NotNull CommandUser user, @NotNull String[] args) {
        Position relative = this.getBasePosition(user);
        boolean serveCoordinateCompletions = user.hasPermission(this.getPermission("coordinates"));
        switch (args.length) {
            case 0: 
            case 1: {
                ArrayList completions = Lists.newArrayList(serveCoordinateCompletions ? List.of("~", "~ ~", "~ ~ ~", Integer.toString((int)relative.getX()), (int)relative.getX() + " " + (int)relative.getY(), (int)relative.getX() + " " + (int)relative.getY() + " " + (int)relative.getZ()) : List.of());
                this.plugin.getUserList().stream().map(User::getName).forEach(completions::add);
                return completions.stream().filter(s -> s.toLowerCase().startsWith(args.length == 1 ? args[0].toLowerCase() : "")).sorted().collect(Collectors.toList());
            }
            case 2: {
                ArrayList<Object> completions = new ArrayList<Object>();
                if (this.isCoordinate(args, 0)) {
                    completions.addAll(List.of("~", Integer.toString((int)relative.getY())));
                    completions.addAll(List.of("~ ~", (int)relative.getY() + " " + (int)relative.getZ()));
                } else {
                    completions.addAll(serveCoordinateCompletions ? List.of("~", "~ ~", "~ ~ ~", Integer.toString((int)relative.getX()), (int)relative.getX() + " " + (int)relative.getY(), (int)relative.getX() + " " + (int)relative.getY() + " " + (int)relative.getZ()) : List.of());
                    if (user.hasPermission(this.getPermission("other"))) {
                        this.plugin.getUserList().stream().map(User::getName).forEach(completions::add);
                    }
                }
                return completions.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).sorted().collect(Collectors.toList());
            }
            case 3: {
                ArrayList<String> completions = new ArrayList<String>();
                if (this.isCoordinate(args, 1) && this.isCoordinate(args, 2)) {
                    if (!serveCoordinateCompletions) {
                        return completions;
                    }
                    completions.addAll(List.of("~", Integer.toString((int)relative.getZ())));
                } else if (this.isCoordinate(args, 1)) {
                    if (!serveCoordinateCompletions) {
                        return completions;
                    }
                    completions.addAll(List.of("~", Integer.toString((int)relative.getY())));
                    completions.addAll(List.of("~ ~", (int)relative.getY() + " " + (int)relative.getZ()));
                }
                return completions.stream().filter(s -> s.toLowerCase().startsWith(args[2].toLowerCase())).sorted().collect(Collectors.toList());
            }
            case 4: {
                ArrayList<String> completions = new ArrayList<String>();
                if (this.isCoordinate(args, 1) && this.isCoordinate(args, 2) && !this.isCoordinate(args, 0)) {
                    if (!serveCoordinateCompletions) {
                        return completions;
                    }
                    completions.addAll(List.of("~", Integer.toString((int)relative.getZ())));
                }
                return completions.stream().filter(s -> s.toLowerCase().startsWith(args[3].toLowerCase())).sorted().collect(Collectors.toList());
            }
        }
        return List.of();
    }

    private boolean isCoordinate(@NotNull String[] args, int index) {
        return this.parseCoordinateArg(args, index, 0.0).isPresent();
    }
}

