/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.configlib.Comment;
import net.william278.huskhomes.libraries.configlib.Configuration;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.util.TransactionResolver;

@Configuration
public final class Settings {
    static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503       HuskHomes Config       \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/huskhomes/\n\u2523\u2578 Config Help: https://william278.net/docs/huskhomes/config-files/\n\u2517\u2578 Documentation: https://william278.net/docs/huskhomes/";
    @Comment(value={"Locale of the default language file to use. Docs: https://william278.net/docs/huskhomes/translations"})
    private String language = "en-gb";
    @Comment(value={"Whether to automatically check for plugin updates on startup"})
    private boolean checkForUpdates = true;
    @Comment(value={"Database settings"})
    private DatabaseSettings database = new DatabaseSettings();
    @Comment(value={"General settings"})
    private GeneralSettings general = new GeneralSettings();
    @Comment(value={"Cross-server settings"})
    private CrossServerSettings crossServer = new CrossServerSettings();
    @Comment(value={"Random teleport (/rtp) settings."})
    private RtpSettings rtp = new RtpSettings();
    @Comment(value={"Action cooldown settings. Docs: https://william278.net/docs/huskhomes/cooldowns"})
    private CooldownSettings cooldowns = new CooldownSettings();
    @Comment(value={"Economy settings. Docs: https://william278.net/docs/huskhomes/economy-hook"})
    private EconomySettings economy = new EconomySettings();
    @Comment(value={"Plan hook settings. Docs: https://william278.net/docs/huskhomes/plan-hook"})
    private PlanHookSettings plan = new PlanHookSettings();
    @Comment(value={"LuckPerms hook settings. Docs: https://william278.net/docs/huskhomes/luckperms-hook"})
    private LuckPermsHookSettings luckperms = new LuckPermsHookSettings();
    @Comment(value={"Web map hook settings. Docs: https://william278.net/docs/huskhomes/map-hooks"})
    private MapHookSettings mapHook = new MapHookSettings();
    @Comment(value={"List of commands to disable (e.g. ['/home', '/warp'] to disable /home and /warp)"})
    private List<String> disabledCommands = Lists.newArrayList();

    public boolean isCommandDisabled(@NotNull Command type) {
        return this.disabledCommands.stream().anyMatch(disabled -> {
            String command = disabled.startsWith("/") ? disabled.substring(1) : disabled;
            return command.equalsIgnoreCase(type.getName()) || type.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(command));
        });
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    @Generated
    public DatabaseSettings getDatabase() {
        return this.database;
    }

    @Generated
    public GeneralSettings getGeneral() {
        return this.general;
    }

    @Generated
    public CrossServerSettings getCrossServer() {
        return this.crossServer;
    }

    @Generated
    public RtpSettings getRtp() {
        return this.rtp;
    }

    @Generated
    public CooldownSettings getCooldowns() {
        return this.cooldowns;
    }

    @Generated
    public EconomySettings getEconomy() {
        return this.economy;
    }

    @Generated
    public PlanHookSettings getPlan() {
        return this.plan;
    }

    @Generated
    public LuckPermsHookSettings getLuckperms() {
        return this.luckperms;
    }

    @Generated
    public MapHookSettings getMapHook() {
        return this.mapHook;
    }

    @Generated
    public List<String> getDisabledCommands() {
        return this.disabledCommands;
    }

    @Generated
    private Settings() {
    }

    @Configuration
    public static class DatabaseSettings {
        @Comment(value={"Type of database to use (SQLITE, H2, MYSQL, MARIADB, or POSTGRESQL)"})
        private Database.Type type = Database.Type.SQLITE;
        @Comment(value={"Specify credentials here if you are using MYSQL, MARIADB, or POSTGRESQL"})
        private DatabaseCredentials credentials = new DatabaseCredentials();
        @Comment(value={"MYSQL / MARIADB / POSTGRESQL database Hikari connection pool properties", "Don't modify this unless you know what you're doing!"})
        private PoolOptions poolOptions = new PoolOptions();
        @Comment(value={"Names of tables to use on your database. Don't modify this unless you know what you're doing!"})
        private Map<Database.Table, String> tableNames = Database.Table.getConfigMap();

        @NotNull
        public String getTableName(@NotNull Database.Table tableName) {
            return Optional.ofNullable(this.tableNames.get((Object)tableName)).orElse(tableName.getDefaultName());
        }

        @Generated
        public Database.Type getType() {
            return this.type;
        }

        @Generated
        public DatabaseCredentials getCredentials() {
            return this.credentials;
        }

        @Generated
        public PoolOptions getPoolOptions() {
            return this.poolOptions;
        }

        @Generated
        public Map<Database.Table, String> getTableNames() {
            return this.tableNames;
        }

        @Generated
        private DatabaseSettings() {
        }

        @Configuration
        public static class DatabaseCredentials {
            private String host = "localhost";
            private int port = 3306;
            private String database = "huskhomes";
            private String username = "root";
            private String password = "pa55w0rd";
            private String parameters = String.join((CharSequence)"&", "?autoReconnect=true", "useSSL=false", "useUnicode=true", "characterEncoding=UTF-8");

            @Generated
            public String getHost() {
                return this.host;
            }

            @Generated
            public int getPort() {
                return this.port;
            }

            @Generated
            public String getDatabase() {
                return this.database;
            }

            @Generated
            public String getUsername() {
                return this.username;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public String getParameters() {
                return this.parameters;
            }

            @Generated
            private DatabaseCredentials() {
            }
        }

        @Configuration
        public static class PoolOptions {
            private int size = 12;
            private int idle = 12;
            private long lifetime = 1800000L;
            private long keepAlive = 30000L;
            private long timeout = 20000L;

            @Generated
            public int getSize() {
                return this.size;
            }

            @Generated
            public int getIdle() {
                return this.idle;
            }

            @Generated
            public long getLifetime() {
                return this.lifetime;
            }

            @Generated
            public long getKeepAlive() {
                return this.keepAlive;
            }

            @Generated
            public long getTimeout() {
                return this.timeout;
            }

            @Generated
            private PoolOptions() {
            }
        }
    }

    @Configuration
    public static class GeneralSettings {
        @Comment(value={"The maximum homes a user can create. Override with the huskhomes.max_homes.<number> permission."})
        private int maxHomes = 10;
        @Comment(value={"The maximum public homes a user can create. Override with the huskhomes.max_public_homes.<number> permission."})
        private int maxPublicHomes = 10;
        @Comment(value={"What character to use between owner usernames and home names when specifying a home or public home.", "(e.g. the '.' in: /phome username.home_name). Change if you're using '.' as the Bedrock user prefix."})
        private String homeDelimiter = ".";
        @Comment(value={"Whether permission limits (i.e. huskhomes.max_homes.<number>) should stack if the user inherits multiple nodes."})
        private boolean stackPermissionLimits = false;
        @Comment(value={"Whether users require a permission (huskhomes.warp.<warp_name>) to use warps"})
        private boolean permissionRestrictWarps = false;
        @Comment(value={"How long a player has to stand still and not take damage for when teleporting (in seconds) "})
        private int teleportWarmupTime = 5;
        @Comment(value={"Whether the teleport warmup timer should be cancelled if the player takes damage"})
        private boolean teleportWarmupCancelOnDamage = true;
        @Comment(value={"Whether the teleport warmup timer should be cancelled if the player moves"})
        private boolean teleportWarmupCancelOnMove = true;
        @Comment(value={"Where the teleport warmup timer should display (CHAT, ACTION_BAR, TITLE, SUBTITLE or NONE)"})
        private Locales.DisplaySlot teleportWarmupDisplay = Locales.DisplaySlot.ACTION_BAR;
        @Comment(value={"How long the player should be invulnerable for after teleporting (in seconds)"})
        private int teleportInvulnerabilityTime = 0;
        @Comment(value={"How long before received teleport requests expire (in seconds)"})
        private int teleportRequestExpiryTime = 60;
        @Comment(value={"Whether /tpa should use the location of the sender when accepted. "})
        private boolean strictTpaRequests = false;
        @Comment(value={"Whether /tpahere should use the location of the sender when sent. Docs: https://william278.net/docs/huskhomes/strict-tpahere/"})
        private boolean strictTpaHereRequests = true;
        @Comment(value={"How many items should be displayed per-page in chat menu lists"})
        private int listItemsPerPage = 12;
        @Comment(value={"Whether the user should always be put back at the /spawn point when they die (ignores beds/respawn anchors)"})
        private boolean alwaysRespawnAtSpawn = false;
        @Comment(value={"Whether teleportation should be carried out async (ensuring chunks load before teleporting)"})
        private boolean teleportAsync = true;
        @Comment(value={"Settings for home and warp names"})
        private NameSettings names = new NameSettings();
        @Comment(value={"Settings for home and warp descriptions"})
        private DescriptionSettings descriptions = new DescriptionSettings();
        @Comment(value={"Settings for the /back command"})
        private BackCommandSettings backCommand = new BackCommandSettings();
        @Comment(value={"Settings for sound effects"})
        private SoundEffectSettings soundEffects = new SoundEffectSettings();

        @Generated
        public int getMaxHomes() {
            return this.maxHomes;
        }

        @Generated
        public int getMaxPublicHomes() {
            return this.maxPublicHomes;
        }

        @Generated
        public String getHomeDelimiter() {
            return this.homeDelimiter;
        }

        @Generated
        public boolean isStackPermissionLimits() {
            return this.stackPermissionLimits;
        }

        @Generated
        public boolean isPermissionRestrictWarps() {
            return this.permissionRestrictWarps;
        }

        @Generated
        public int getTeleportWarmupTime() {
            return this.teleportWarmupTime;
        }

        @Generated
        public boolean isTeleportWarmupCancelOnDamage() {
            return this.teleportWarmupCancelOnDamage;
        }

        @Generated
        public boolean isTeleportWarmupCancelOnMove() {
            return this.teleportWarmupCancelOnMove;
        }

        @Generated
        public Locales.DisplaySlot getTeleportWarmupDisplay() {
            return this.teleportWarmupDisplay;
        }

        @Generated
        public int getTeleportInvulnerabilityTime() {
            return this.teleportInvulnerabilityTime;
        }

        @Generated
        public int getTeleportRequestExpiryTime() {
            return this.teleportRequestExpiryTime;
        }

        @Generated
        public boolean isStrictTpaRequests() {
            return this.strictTpaRequests;
        }

        @Generated
        public boolean isStrictTpaHereRequests() {
            return this.strictTpaHereRequests;
        }

        @Generated
        public int getListItemsPerPage() {
            return this.listItemsPerPage;
        }

        @Generated
        public boolean isAlwaysRespawnAtSpawn() {
            return this.alwaysRespawnAtSpawn;
        }

        @Generated
        public boolean isTeleportAsync() {
            return this.teleportAsync;
        }

        @Generated
        public NameSettings getNames() {
            return this.names;
        }

        @Generated
        public DescriptionSettings getDescriptions() {
            return this.descriptions;
        }

        @Generated
        public BackCommandSettings getBackCommand() {
            return this.backCommand;
        }

        @Generated
        public SoundEffectSettings getSoundEffects() {
            return this.soundEffects;
        }

        @Generated
        private GeneralSettings() {
        }

        @Configuration
        public static class NameSettings {
            @Comment(value={"Whether running /sethome <name> or /setwarp <name> when one already exists should overwrite."})
            private boolean overwriteExisting = true;
            @Comment(value={"Whether home or warp names should be case insensitive (i.e. allow /home HomeOne & /home homeone)"})
            private boolean caseInsensitive = false;
            @Comment(value={"Whether home and warp names should be restricted to a regex filter.Set this to false to allow full UTF-8 names (i.e. allow /home \u4f60\u597d)."})
            private boolean restrict = true;
            @Comment(value={"Regex which home and warp names must match. Names have a max length of 16 characters"})
            private String regex = "[a-zA-Z0-9-_]*";

            @Generated
            public boolean isOverwriteExisting() {
                return this.overwriteExisting;
            }

            @Generated
            public boolean isCaseInsensitive() {
                return this.caseInsensitive;
            }

            @Generated
            public boolean isRestrict() {
                return this.restrict;
            }

            @Generated
            public String getRegex() {
                return this.regex;
            }

            @Generated
            private NameSettings() {
            }
        }

        @Configuration
        public static class DescriptionSettings {
            @Comment(value={"Whether home/warp descriptions should be restricted to a regex filter. Set this to true to restrict UTF-8 usage."})
            private boolean restrict = false;
            @Comment(value={"Regex which home and warp descriptions must match. A hard max length of 256 characters is enforced"})
            private String regex = "\\A\\p{ASCII}*\\z";

            @Generated
            public boolean isRestrict() {
                return this.restrict;
            }

            @Generated
            public String getRegex() {
                return this.regex;
            }

            @Generated
            private DescriptionSettings() {
            }
        }

        @Configuration
        public static class BackCommandSettings {
            @Comment(value={"Whether /back should work to teleport the user to where they died"})
            private boolean returnByDeath = true;
            @Comment(value={"Whether /back should work with other plugins that use the PlayerTeleportEvent (can conflict)"})
            private boolean saveOnTeleportEvent = false;
            @Comment(value={"List of world names where the /back command cannot RETURN the player to. ", "A user's last position won't be updated if they die or teleport from these worlds, but they still will be able to use the command while IN the world."})
            private List<String> restrictedWorlds = new ArrayList<String>();

            public boolean canReturnToWorld(@NotNull World world) {
                String name = world.getName();
                String formattedName = name.replace("minecraft:", "");
                return this.restrictedWorlds.stream().map(n -> n.replace("minecraft:", "")).noneMatch(n -> n.equalsIgnoreCase(formattedName));
            }

            @Generated
            public boolean isReturnByDeath() {
                return this.returnByDeath;
            }

            @Generated
            public boolean isSaveOnTeleportEvent() {
                return this.saveOnTeleportEvent;
            }

            @Generated
            public List<String> getRestrictedWorlds() {
                return this.restrictedWorlds;
            }

            @Generated
            private BackCommandSettings() {
            }
        }

        @Configuration
        public static class SoundEffectSettings {
            @Comment(value={"Whether to play sound effects"})
            private boolean enabled = true;
            @Comment(value={"Map of sound effect actions to types"})
            private Map<SoundEffectAction, String> types = SoundEffectAction.getDefaults();

            @NotNull
            public Optional<String> get(@NotNull SoundEffectAction action) {
                if (!this.enabled) {
                    return Optional.empty();
                }
                return Optional.ofNullable(this.types.get((Object)action));
            }

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public Map<SoundEffectAction, String> getTypes() {
                return this.types;
            }

            @Generated
            private SoundEffectSettings() {
            }
        }
    }

    @Configuration
    public static class CrossServerSettings {
        @Comment(value={"Whether to enable cross-server mode for teleporting across your proxy network."})
        private boolean enabled = false;
        @Comment(value={"The cluster ID, for if you're networking multiple separate groups of HuskHomes-enabled servers.", "Do not change unless you know what you're doing"})
        private String clusterId = "main";
        @Comment(value={"Type of network message broker to ues for cross-server networking (PLUGIN_MESSAGE or REDIS)"})
        private Broker.Type brokerType = Broker.Type.PLUGIN_MESSAGE;
        @Comment(value={"Settings for if you're using REDIS as your message broker"})
        private RedisSettings redis = new RedisSettings();
        @Comment(value={"Define a single global /spawn for your network via a warp. Docs: https://william278.net/docs/huskhomes/global-spawn/"})
        private GlobalSpawnSettings globalSpawn = new GlobalSpawnSettings();
        @Comment(value={"Whether player respawn positions should work cross-server. Docs: https://william278.net/docs/huskhomes/global-respawning/"})
        private boolean globalRespawning = false;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getClusterId() {
            return this.clusterId;
        }

        @Generated
        public Broker.Type getBrokerType() {
            return this.brokerType;
        }

        @Generated
        public RedisSettings getRedis() {
            return this.redis;
        }

        @Generated
        public GlobalSpawnSettings getGlobalSpawn() {
            return this.globalSpawn;
        }

        @Generated
        public boolean isGlobalRespawning() {
            return this.globalRespawning;
        }

        @Generated
        private CrossServerSettings() {
        }

        @Configuration
        public static class RedisSettings {
            private String host = "localhost";
            private int port = 6379;
            @Comment(value={"Only change this if you know what you are doing. The default value is 0."})
            private int database = 0;
            @Comment(value={"Password for your Redis server. Leave blank if you're not using a password."})
            private String password = "";
            @Comment(value={"Timeout for connecting to the Redis server (in milliseconds)"})
            private int timeout = 2000;
            private boolean useSsl = false;
            @Comment(value={"Settings for if you're using Redis Sentinels.", "If you're not sure what this is, please ignore this section."})
            private SentinelSettings sentinel = new SentinelSettings();

            @Generated
            public String getHost() {
                return this.host;
            }

            @Generated
            public int getPort() {
                return this.port;
            }

            @Generated
            public int getDatabase() {
                return this.database;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public int getTimeout() {
                return this.timeout;
            }

            @Generated
            public boolean isUseSsl() {
                return this.useSsl;
            }

            @Generated
            public SentinelSettings getSentinel() {
                return this.sentinel;
            }

            @Generated
            public RedisSettings() {
            }

            @Configuration
            public static class SentinelSettings {
                private String masterName = "";
                @Comment(value={"List of host:port pairs"})
                private List<String> nodes = Lists.newArrayList();
                private String password = "";

                @Generated
                public String getMasterName() {
                    return this.masterName;
                }

                @Generated
                public List<String> getNodes() {
                    return this.nodes;
                }

                @Generated
                public String getPassword() {
                    return this.password;
                }

                @Generated
                public SentinelSettings() {
                }
            }
        }

        @Configuration
        public static class GlobalSpawnSettings {
            @Comment(value={"Whether to define a single global /spawn for your network via a warp."})
            private boolean enabled = false;
            @Comment(value={"The name of the warp to use as the global spawn."})
            private String warpName = "Spawn";

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public String getWarpName() {
                return this.warpName;
            }

            @Generated
            public GlobalSpawnSettings() {
            }
        }
    }

    @Configuration
    public static class RtpSettings {
        @Comment(value={"Radial region around the /spawn position where players CAN be randomly teleported.", "If no /spawn has been set, (0, 0) will be used instead."})
        private RtpRadius region = new RtpRadius();
        @Comment(value={"Mean of the normal distribution used to calculate the distance from the center of the world"})
        private float distributionMean = 0.75f;
        @Comment(value={"Standard deviation of the normal distribution for distributing players randomly"})
        private float distributionStandardDeviation = 2.0f;
        @Comment(value={"Set the minimum random teleportation height for each world", "List of world_name:height pairs"})
        private List<String> minHeight = Lists.newArrayList();
        @Comment(value={"Set the maximum random teleportation height for each world", "List of world_name:height pairs"})
        private List<String> maxHeight = Lists.newArrayList();
        @Comment(value={"List of worlds in which /rtp is disabled. Please note that /rtp does not work well in the nether."})
        private List<String> restrictedWorlds = List.of("world_nether", "world_the_end");
        @Comment(value={"Whether or not RTP should perform cross-server."})
        private boolean crossServer = false;
        @Comment(value={"List of server in which /rtp is allowed. (Only relevant when using cross server mode WITH REDIS)", "If a server is not defined here the RTP logic has no way of knowing its existence."})
        private Map<String, List<String>> randomTargetServers = new HashMap<String, List<String>>(Map.of("server", List.of("world", "world_nether", "world_the_end")));

        public boolean isWorldRtpRestricted(@NotNull World world) {
            String name = world.getName();
            String formattedName = name.replace("minecraft:", "");
            return this.restrictedWorlds.stream().map(n -> n.replace("minecraft:", "")).anyMatch(n -> n.equalsIgnoreCase(formattedName));
        }

        @Generated
        public RtpRadius getRegion() {
            return this.region;
        }

        @Generated
        public float getDistributionMean() {
            return this.distributionMean;
        }

        @Generated
        public float getDistributionStandardDeviation() {
            return this.distributionStandardDeviation;
        }

        @Generated
        public List<String> getMinHeight() {
            return this.minHeight;
        }

        @Generated
        public List<String> getMaxHeight() {
            return this.maxHeight;
        }

        @Generated
        public List<String> getRestrictedWorlds() {
            return this.restrictedWorlds;
        }

        @Generated
        public boolean isCrossServer() {
            return this.crossServer;
        }

        @Generated
        public Map<String, List<String>> getRandomTargetServers() {
            return this.randomTargetServers;
        }

        @Generated
        public RtpSettings() {
        }

        @Configuration
        public static class RtpRadius {
            private int min = 500;
            private int max = 5000;

            @Generated
            public int getMin() {
                return this.min;
            }

            @Generated
            public int getMax() {
                return this.max;
            }

            @Generated
            public RtpRadius() {
            }
        }
    }

    @Configuration
    public static class CooldownSettings {
        @Comment(value={"Whether to apply a cooldown between performing certain actions"})
        private boolean enabled = true;
        @Comment(value={"Map of cooldown times to actions"})
        private Map<TransactionResolver.Action, Long> cooldownTimes = TransactionResolver.Action.getCooldownTimes();

        public long getCooldown(@NotNull TransactionResolver.Action action) {
            return this.enabled ? this.cooldownTimes.getOrDefault((Object)action, 0L) : 0L;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<TransactionResolver.Action, Long> getCooldownTimes() {
            return this.cooldownTimes;
        }

        @Generated
        public CooldownSettings() {
        }
    }

    @Configuration
    public static class EconomySettings {
        @Comment(value={"Enable economy plugin integration (requires Vault and a compatible Economy plugin)"})
        private boolean enabled = false;
        @Comment(value={"Map of economy actions to costs."})
        private Map<TransactionResolver.Action, Double> economyCosts = TransactionResolver.Action.getEconomyCosts();
        @Comment(value={"Specify how many homes players can set for free, before they need to pay for more slots"})
        private int freeHomeSlots = 5;

        public Optional<Double> getCost(@NotNull TransactionResolver.Action action) {
            if (!this.enabled) {
                return Optional.empty();
            }
            return this.economyCosts.containsKey((Object)action) ? Optional.of(this.economyCosts.get((Object)action)) : Optional.empty();
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<TransactionResolver.Action, Double> getEconomyCosts() {
            return this.economyCosts;
        }

        @Generated
        public int getFreeHomeSlots() {
            return this.freeHomeSlots;
        }

        @Generated
        public EconomySettings() {
        }
    }

    @Configuration
    public static class PlanHookSettings {
        @Comment(value={"Hook into Player Analytics to provide HuskHomes statistics in your web dashboard."})
        private boolean enabled = true;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public PlanHookSettings() {
        }
    }

    @Configuration
    public static class LuckPermsHookSettings {
        @Comment(value={"Hook into LuckPerms for more accurate numerical permission calculations"})
        private boolean enabled = true;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public LuckPermsHookSettings() {
        }
    }

    @Configuration
    public static class MapHookSettings {
        @Comment(value={"Display public homes/warps on your Dynmap, BlueMap or Pl3xMap"})
        private boolean enabled = true;
        @Comment(value={"Show public homes on the web map"})
        private boolean showPublicHomes = true;
        @Comment(value={"Show warps on the web map"})
        private boolean showWarps = true;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isShowPublicHomes() {
            return this.showPublicHomes;
        }

        @Generated
        public boolean isShowWarps() {
            return this.showWarps;
        }

        @Generated
        public MapHookSettings() {
        }
    }

    public static enum SoundEffectAction {
        TELEPORTATION_COMPLETE("entity.enderman.teleport"),
        TELEPORTATION_WARMUP("block.note_block.banjo"),
        TELEPORTATION_CANCELLED("entity.item.break"),
        TELEPORT_REQUEST_RECEIVED("entity.experience_orb.pickup");

        private final String defaultEffect;

        private SoundEffectAction(String defaultEffect) {
            this.defaultEffect = defaultEffect;
        }

        @NotNull
        public static Map<SoundEffectAction, String> getDefaults() {
            return Arrays.stream(SoundEffectAction.values()).collect(Collectors.toMap(action -> action, action -> action.defaultEffect, (a, b) -> a, TreeMap::new));
        }
    }
}

