/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.user;

import java.util.UUID;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.UserProvider;
import org.bukkit.entity.Player;

public interface BukkitUserProvider
extends UserProvider {
    @Override
    @NotNull
    default public OnlineUser getOnlineUser(@NotNull UUID uuid) {
        return this.getOnlineUser(this.getPlugin().getServer().getPlayer(uuid));
    }

    @NotNull
    default public BukkitUser getOnlineUser(@Nullable Player player) {
        if (player == null) {
            throw new IllegalArgumentException("Player is not online");
        }
        BukkitUser user = (BukkitUser)this.getOnlineUserMap().get(player.getUniqueId());
        if (user == null || !user.getPlayer().isOnline()) {
            user = BukkitUser.adapt(player, this.getPlugin());
            this.getOnlineUserMap().put(player.getUniqueId(), user);
            return user;
        }
        return user;
    }

    @Override
    @NotNull
    public BukkitHuskHomes getPlugin();
}

