/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.teleport;

import java.time.Instant;
import lombok.Generated;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.gson.annotations.Expose;
import net.william278.huskhomes.libraries.gson.annotations.SerializedName;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.user.OnlineUser;

public class TeleportRequest {
    @Expose
    @SerializedName(value="requester_name")
    private String requesterName;
    @Expose
    @SerializedName(value="requester_position")
    private Position requesterPosition;
    @Expose
    @SerializedName(value="expiry_time")
    private long expiryTime;
    @Expose
    private Type type;
    @Expose
    private Status status;
    @Expose
    @SerializedName(value="recipient_name")
    private String recipientName;

    public TeleportRequest(@NotNull OnlineUser requester, @NotNull Type type, long expiryTime) {
        this.setRequesterName(requester.getName());
        this.setRequesterPosition(requester.getPosition());
        this.setType(type);
        this.setStatus(Status.PENDING);
        this.expiryTime = expiryTime;
    }

    public boolean hasExpired() {
        return Instant.now().isAfter(Instant.ofEpochSecond(this.expiryTime));
    }

    @Generated
    public String getRequesterName() {
        return this.requesterName;
    }

    @Generated
    public Position getRequesterPosition() {
        return this.requesterPosition;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public String getRecipientName() {
        return this.recipientName;
    }

    @Generated
    public void setRequesterName(String requesterName) {
        this.requesterName = requesterName;
    }

    @Generated
    public void setRequesterPosition(Position requesterPosition) {
        this.requesterPosition = requesterPosition;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    @Generated
    private TeleportRequest() {
    }

    public static enum Type {
        TPA,
        TPA_HERE;

    }

    public static enum Status {
        PENDING,
        ACCEPTED,
        DECLINED,
        IGNORED;

    }
}

