/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.manager;

import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.manager.HomesManager;
import net.william278.huskhomes.manager.RequestsManager;
import net.william278.huskhomes.manager.WarpsManager;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.user.OnlineUser;

public class Manager {
    private final HuskHomes plugin;
    private final HomesManager homes;
    private final WarpsManager warps;
    private final RequestsManager requests;

    public Manager(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
        this.homes = new HomesManager(plugin);
        this.warps = new WarpsManager(plugin);
        this.requests = new RequestsManager(plugin);
    }

    @NotNull
    public HomesManager homes() {
        return this.homes;
    }

    @NotNull
    public WarpsManager warps() {
        return this.warps;
    }

    @NotNull
    public RequestsManager requests() {
        return this.requests;
    }

    protected void propagateCacheUpdate() {
        this.plugin.getBroker().ifPresent(b -> this.plugin.getOnlineUsers().stream().findAny().ifPresent(user -> Message.builder().type(Message.MessageType.UPDATE_CACHES).target("ALL", Message.TargetType.SERVER).build().send((Broker)b, (OnlineUser)user)));
    }
}

