/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.listener;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.BackCommand;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.libraries.annotations.Blocking;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;

public abstract class EventListener {
    @NotNull
    private final HuskHomes plugin;

    public abstract void register();

    protected final void handlePlayerJoin(@NotNull OnlineUser onlineUser) {
        this.plugin.runAsync(() -> {
            this.plugin.getDatabase().ensureUser(onlineUser);
            this.plugin.getCurrentlyOnWarmup().remove(onlineUser.getUuid());
            if (this.plugin.getSettings().getCrossServer().isEnabled()) {
                this.handleInboundTeleport(onlineUser);
                this.plugin.runSyncDelayed(() -> this.updateUserList(onlineUser, this.plugin.getOnlineUsers().stream().map(u -> u).toList()), onlineUser, 40L);
                if (this.plugin.getOnlineUsers().size() == 1) {
                    this.plugin.getManager().homes().updatePublicHomeCache();
                    this.plugin.getManager().warps().updateWarpCache();
                }
            }
            this.plugin.getManager().homes().cacheUserHomes(onlineUser);
            this.plugin.getDatabase().getUser(onlineUser.getUuid()).ifPresent(userData -> {
                this.plugin.getSavedUsers().add((SavedUser)userData);
                if (userData.isIgnoringTeleports()) {
                    this.plugin.getLocales().getRawLocale("tpignore_on_notification", this.plugin.getLocales().getRawLocale("tpignore_toggle_button").orElse("")).ifPresent(locale -> onlineUser.sendMessage(new MineDown((String)locale)));
                }
            });
        });
    }

    protected final void handlePlayerLeave(@NotNull OnlineUser online) {
        this.plugin.getOnlineUserMap().remove(online.getUuid());
        online.removeInvulnerabilityIfPermitted();
        this.plugin.runAsync(() -> {
            this.plugin.getDatabase().setOfflinePosition(online, online.getPosition());
            this.plugin.getManager().homes().removeUserHomes(online);
            if (this.plugin.getSettings().getCrossServer().isEnabled()) {
                List<User> users = this.plugin.getOnlineUsers().stream().map(u -> u).toList();
                if (this.plugin.getSettings().getCrossServer().getBrokerType() == Broker.Type.REDIS) {
                    this.updateUserList(online, users);
                    return;
                }
                this.plugin.getOnlineUsers().stream().filter(user -> !user.equals(online)).findAny().ifPresent(player -> this.updateUserList((OnlineUser)player, users));
            }
        });
    }

    private void handleInboundTeleport(@NotNull OnlineUser teleporter) {
        this.plugin.getDatabase().getCurrentTeleport(teleporter).ifPresent(teleport -> {
            if (teleport.getType() == Teleport.Type.RESPAWN) {
                this.handleInboundRespawn(teleporter);
                return;
            }
            try {
                teleporter.teleportLocally((Position)teleport.getTarget(), this.plugin.getSettings().getGeneral().isTeleportAsync());
            }
            catch (TeleportationException e) {
                e.displayMessage(teleporter, new String[0]);
            }
            this.plugin.getDatabase().clearCurrentTeleport(teleporter);
            teleport.displayTeleportingComplete(teleporter);
            teleporter.handleInvulnerability();
        });
    }

    private void handleInboundRespawn(@NotNull OnlineUser teleporter) {
        Optional<Position> bedPosition = teleporter.getBedSpawnPosition();
        if (bedPosition.isEmpty()) {
            this.plugin.getSpawn().ifPresent(spawn -> {
                if (this.plugin.getSettings().getCrossServer().isEnabled() && !spawn.getServer().equals(this.plugin.getServerName())) {
                    this.plugin.runSyncDelayed(() -> Teleport.builder(this.plugin).teleporter(teleporter).target((Target)spawn).updateLastPosition(false).buildAndComplete(false, new String[0]), teleporter, 40L);
                } else {
                    try {
                        teleporter.teleportLocally((Location)spawn, this.plugin.getSettings().getGeneral().isTeleportAsync());
                    }
                    catch (TeleportationException e) {
                        e.displayMessage(teleporter, new String[0]);
                    }
                }
                teleporter.sendTranslatableMessage("block.minecraft.spawn.not_valid");
            });
        } else {
            try {
                teleporter.teleportLocally(bedPosition.get(), this.plugin.getSettings().getGeneral().isTeleportAsync());
            }
            catch (TeleportationException e) {
                e.displayMessage(teleporter, new String[0]);
            }
        }
        this.plugin.getDatabase().clearCurrentTeleport(teleporter);
        this.plugin.getDatabase().setRespawnPosition(teleporter, bedPosition.orElse(null));
    }

    private void updateUserList(@NotNull OnlineUser user, @NotNull List<User> localPlayerList) {
        this.plugin.getBroker().ifPresent(broker -> {
            Message.builder().type(Message.MessageType.UPDATE_USER_LIST).target("ALL", Message.TargetType.SERVER).payload(Payload.userList(localPlayerList)).build().send((Broker)broker, user);
            if (this.plugin.getOnlineUsers().size() == 1) {
                this.plugin.getGlobalUserList().clear();
                Message.builder().type(Message.MessageType.REQUEST_USER_LIST).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, user);
            }
        });
    }

    protected final void handlePlayerDeath(@NotNull OnlineUser onlineUser) {
        Position lastPosition = onlineUser.getPosition();
        World lastWorld = lastPosition.getWorld();
        BackCommand command = this.plugin.getCommand(BackCommand.class).orElse(null);
        if (command == null || !onlineUser.hasPermission(command.getPermission(new String[0])) || !onlineUser.hasPermission(command.getPermission("death"))) {
            return;
        }
        Settings.GeneralSettings.BackCommandSettings back = this.plugin.getSettings().getGeneral().getBackCommand();
        if (!back.isReturnByDeath() || !back.canReturnToWorld(lastWorld)) {
            return;
        }
        this.plugin.runAsync(() -> {
            this.plugin.getDatabase().setLastPosition(onlineUser, lastPosition);
            this.plugin.getLocales().getLocale("return_by_death_notification").ifPresent(onlineUser::sendMessage);
        });
    }

    protected final void handlePlayerRespawn(@NotNull OnlineUser onlineUser) {
        Settings.CrossServerSettings crossServer = this.plugin.getSettings().getCrossServer();
        if (!crossServer.isEnabled() || !crossServer.isGlobalRespawning()) {
            return;
        }
        this.plugin.runAsync(() -> this.respawnGlobally(onlineUser));
    }

    @Blocking
    private void respawnGlobally(@NotNull OnlineUser onlineUser) {
        TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(onlineUser).type(Teleport.Type.RESPAWN).updateLastPosition(false);
        this.plugin.getDatabase().getRespawnPosition(onlineUser).flatMap(pos -> {
            if (pos.getServer().equals(this.plugin.getServerName()) && onlineUser.getBedSpawnPosition().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(pos);
        }).or(() -> {
            builder.type(Teleport.Type.TELEPORT);
            return this.plugin.getSpawn();
        }).ifPresent(pos -> {
            builder.target((Target)pos);
            try {
                builder.toTeleport().execute();
            }
            catch (TeleportationException e) {
                e.displayMessage(onlineUser, new String[0]);
            }
        });
    }

    protected final void handlePlayerTeleport(@NotNull OnlineUser onlineUser, @NotNull Position sourcePosition) {
        Settings.GeneralSettings.BackCommandSettings back = this.plugin.getSettings().getGeneral().getBackCommand();
        if (back.isSaveOnTeleportEvent() && back.canReturnToWorld(sourcePosition.getWorld())) {
            this.plugin.runAsync(() -> this.plugin.getDatabase().setLastPosition(onlineUser, sourcePosition));
        }
    }

    protected final void handlePlayerUpdateSpawnPoint(@NotNull OnlineUser onlineUser, @NotNull Position position) {
        if (!this.plugin.getSettings().getGeneral().isAlwaysRespawnAtSpawn() && this.plugin.getSettings().getCrossServer().isEnabled() && this.plugin.getSettings().getCrossServer().isGlobalRespawning()) {
            this.plugin.getDatabase().setRespawnPosition(onlineUser, position);
        }
    }

    @NotNull
    protected HuskHomes getPlugin() {
        return this.plugin;
    }

    @Generated
    protected EventListener(@NotNull HuskHomes plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }
}

