/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.query.QueryOptions;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.user.OnlineUser;

@PluginHook(name="LuckPerms", register=PluginHook.Register.ON_ENABLE)
public class LuckPermsHook
extends Hook {
    private LuckPerms api;

    public LuckPermsHook(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void load() {
        this.api = LuckPermsProvider.get();
    }

    @Override
    public void unload() {
        this.api = null;
    }

    @NotNull
    public List<Integer> getNumericalPermissions(@NotNull OnlineUser online, @NotNull String nodePrefix) {
        User user = this.api.getUserManager().getUser(online.getUuid());
        if (user == null) {
            return List.of();
        }
        return user.resolveInheritedNodes(QueryOptions.contextual((ContextSet)LuckPermsHook.getContexts(online))).stream().filter(Node::getValue).filter(n -> n.getKey().startsWith(nodePrefix)).filter(perm -> LuckPermsHook.canParse(perm, nodePrefix)).map(perm -> Integer.parseInt(perm.getKey().substring(nodePrefix.length()))).sorted(Collections.reverseOrder()).toList();
    }

    @NotNull
    private static ImmutableContextSet getContexts(@NotNull OnlineUser user) {
        World world = user.getPosition().getWorld();
        return ImmutableContextSet.builder().add("world", world.getName()).add("server", user.getPosition().getServer()).add("dimension-type", world.getEnvironment().name().toLowerCase(Locale.ENGLISH)).build();
    }

    private static boolean canParse(@NotNull Node permission, @NotNull String nodePrefix) {
        try {
            Integer.parseInt(permission.getKey().substring(nodePrefix.length()));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

