/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.util.List;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.HookProvider;
import net.william278.huskhomes.hook.PlaceholderAPIHook;
import net.william278.huskhomes.hook.VaultEconomyHook;
import net.william278.huskhomes.importer.EssentialsXImporter;
import net.william278.huskhomes.libraries.annotations.NotNull;

public interface BukkitHookProvider
extends HookProvider {
    @Override
    @NotNull
    default public List<Hook> getAvailableHooks() {
        List<Hook> hooks = HookProvider.super.getAvailableHooks();
        Settings settings = this.getPlugin().getSettings();
        if (this.isDependencyAvailable("Vault") && settings.getEconomy().isEnabled()) {
            hooks.add(new VaultEconomyHook(this.getPlugin()));
        }
        if (this.isDependencyAvailable("PlaceholderAPI")) {
            hooks.add(new PlaceholderAPIHook(this.getPlugin()));
        }
        if (this.isDependencyAvailable("Essentials")) {
            hooks.add(new EssentialsXImporter(this.getPlugin()));
        }
        return hooks;
    }

    @Override
    default public boolean isDependencyAvailable(@NotNull String name) {
        return this.getPlugin().getServer().getPluginManager().getPlugin(name) != null;
    }

    @Override
    @NotNull
    public BukkitHuskHomes getPlugin();
}

