/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.util.ValidationException;

public interface TextValidator {
    public static final int MAX_NAME_LENGTH = 16;
    public static final int MAX_DESCRIPTION_LENGTH = 256;

    default public void validateName(@NotNull String name) throws ValidationException {
        if (!this.isValidNameCharacters(name)) {
            throw new ValidationException(ValidationException.Type.NAME_INVALID_CHARACTERS);
        }
        if (!this.isValidNameLength(name)) {
            throw new ValidationException(ValidationException.Type.NAME_INVALID_LENGTH);
        }
    }

    default public void validateDescription(@NotNull String description) throws ValidationException {
        if (!this.isValidDescriptionCharacters(description)) {
            throw new ValidationException(ValidationException.Type.DESCRIPTION_INVALID_CHARACTERS);
        }
        if (!this.isValidDescriptionLength(description)) {
            throw new ValidationException(ValidationException.Type.DESCRIPTION_INVALID_LENGTH);
        }
    }

    private boolean isValidNameCharacters(@NotNull String name) {
        Settings.GeneralSettings.NameSettings config = this.getSettings().getGeneral().getNames();
        return (name.matches(config.getRegex()) || !config.isRestrict()) && !name.contains("\u0000") && !this.containsWhitespace(name) && !name.contains(Home.getDelimiter());
    }

    private boolean isValidNameLength(@NotNull String name) {
        return name.length() <= 16 && !name.isEmpty();
    }

    private boolean isValidDescriptionCharacters(@NotNull String description) {
        Settings.GeneralSettings.DescriptionSettings config = this.getSettings().getGeneral().getDescriptions();
        return (description.matches(config.getRegex()) || !config.isRestrict()) && !description.contains("\u0000");
    }

    private boolean isValidDescriptionLength(@NotNull String description) {
        return description.length() <= 256;
    }

    private boolean containsWhitespace(@NotNull String string) {
        return string.matches(".*\\s.*");
    }

    @NotNull
    public HuskHomes getPlugin();

    @NotNull
    public Settings getSettings();
}

