/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.importer.Importer;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.commons.text.WordUtils;
import net.william278.huskhomes.position.Home;

public enum StatusLine {
    PLUGIN_VERSION(plugin -> ((TextComponent)Component.text("v" + plugin.getPluginVersion().toStringWithoutMetadata()).appendSpace()).append(plugin.getPluginVersion().getMetadata().isBlank() ? Component.empty() : Component.text("(build " + plugin.getPluginVersion().getMetadata() + ")"))),
    SERVER_VERSION(plugin -> Component.text(plugin.getServerType())),
    LANGUAGE(plugin -> Component.text(plugin.getSettings().getLanguage())),
    MINECRAFT_VERSION(plugin -> Component.text(plugin.getMinecraftVersion().toString())),
    JAVA_VERSION(plugin -> Component.text(System.getProperty("java.version"))),
    JAVA_VENDOR(plugin -> Component.text(System.getProperty("java.vendor"))),
    IS_CROSS_SERVER(plugin -> StatusLine.getBoolean(plugin.getSettings().getCrossServer().isEnabled())),
    MESSAGE_BROKER_TYPE(plugin -> Component.text(plugin.getSettings().getCrossServer().getBrokerType().getDisplayName())),
    SERVER_NAME(plugin -> Component.text(plugin.getServerName())),
    DATABASE_TYPE(plugin -> Component.text(plugin.getSettings().getDatabase().getType().getDisplayName())),
    IS_DATABASE_LOCAL(plugin -> StatusLine.getLocalhostBoolean(plugin.getSettings().getDatabase().getCredentials().getHost())),
    USING_REDIS_SENTINEL(plugin -> StatusLine.getBoolean(!plugin.getSettings().getCrossServer().getRedis().getSentinel().getMasterName().isBlank())),
    USING_REDIS_PASSWORD(plugin -> StatusLine.getBoolean(!plugin.getSettings().getCrossServer().getRedis().getPassword().isBlank())),
    REDIS_USING_SSL(plugin -> StatusLine.getBoolean(!plugin.getSettings().getCrossServer().getRedis().isUseSsl())),
    IS_REDIS_LOCAL(plugin -> StatusLine.getLocalhostBoolean(plugin.getSettings().getCrossServer().getRedis().getHost())),
    ECONOMY_MODE(plugin -> StatusLine.getBoolean(plugin.isUsingEconomy())),
    HOME_DELIMITER(plugin -> Component.text(Home.getDelimiter())),
    LOADED_HOOKS(plugin -> Component.join(JoinConfiguration.commas(true), plugin.getHooks().stream().filter(hook -> !(hook instanceof Importer)).map(hook -> Component.text(hook.getName())).toList())),
    LOADED_IMPORTERS(plugin -> Component.join(JoinConfiguration.commas(true), plugin.getImporters().stream().map(hook -> Component.text(hook.getName())).toList()));

    private final Function<HuskHomes, Component> supplier;

    private StatusLine(Function<HuskHomes, Component> supplier) {
        this.supplier = supplier;
    }

    @NotNull
    public Component get(@NotNull HuskHomes plugin) {
        return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text("\u2022").appendSpace()).append(Component.text(WordUtils.capitalizeFully(this.name().replaceAll("_", " ")), TextColor.color(0x848484)))).append(Component.text(':'))).append(Component.space().color(NamedTextColor.WHITE))).append(this.supplier.apply(plugin));
    }

    @NotNull
    public String getValue(@NotNull HuskHomes plugin) {
        return PlainTextComponentSerializer.plainText().serialize(this.supplier.apply(plugin));
    }

    @NotNull
    private static Component getBoolean(boolean value) {
        return Component.text(value ? "Yes" : "No", (TextColor)(value ? NamedTextColor.GREEN : NamedTextColor.RED));
    }

    @NotNull
    private static Component getLocalhostBoolean(@NotNull String value) {
        return StatusLine.getBoolean(value.equals("127.0.0.1") || value.equals("0.0.0.0") || value.equals("localhost") || value.equals("::1"));
    }
}

