/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.teleport;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.BackCommand;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.event.ITeleportEvent;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.desertwell.util.ThrowingConsumer;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.network.PluginMessageBroker;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Completable;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.teleport.Username;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;

public class Teleport
implements Completable {
    protected final HuskHomes plugin;
    protected final OnlineUser executor;
    protected final Teleportable teleporter;
    protected final Target target;
    protected final Type type;
    protected final List<TransactionResolver.Action> actions;
    private final boolean async;
    protected final boolean updateLastPosition;

    protected Teleport(@NotNull OnlineUser executor, @NotNull Teleportable teleporter, @NotNull Target target, @NotNull Type type, boolean updateLastPosition, @NotNull List<TransactionResolver.Action> actions, @NotNull HuskHomes plugin) {
        this.plugin = plugin;
        this.executor = executor;
        this.teleporter = teleporter;
        this.target = target;
        this.type = type;
        this.actions = actions;
        this.async = plugin.getSettings().getGeneral().isTeleportAsync();
        this.updateLastPosition = updateLastPosition && plugin.getCommand(BackCommand.class).map(command -> executor.hasPermission(command.getPermission(new String[0])) && executor.hasPermission(command.getPermission("previous"))).orElse(false) != false;
    }

    @NotNull
    public static TeleportBuilder builder(@NotNull HuskHomes plugin) {
        return new TeleportBuilder(plugin);
    }

    @Override
    public void execute() throws TeleportationException {
        if (!this.teleporter.isValid()) {
            throw new TeleportationException(TeleportationException.Type.TELEPORTER_INVALID, this.plugin);
        }
        this.validateTransactions();
        this.resolveLocalTeleporter().ifPresentOrElse(this::executeLocal, this::executeRemote);
    }

    private void executeLocal(@NotNull OnlineUser teleporter) throws TeleportationException {
        Target target = this.target;
        if (target instanceof Username) {
            Optional<OnlineUser> localTarget;
            Username username = (Username)target;
            Optional<OnlineUser> optional = localTarget = username.name().equals("@s") ? Optional.of(this.executor) : username.findLocally(this.plugin);
            if (localTarget.isPresent()) {
                this.fireEvent(event -> {
                    this.performTransactions();
                    if (this.updateLastPosition && this.canReturnToWorld(teleporter)) {
                        this.plugin.getDatabase().setLastPosition(teleporter, teleporter.getPosition());
                    }
                    teleporter.teleportLocally(((OnlineUser)localTarget.get()).getPosition(), this.async);
                    this.displayTeleportingComplete(teleporter);
                    teleporter.handleInvulnerability();
                });
                return;
            }
            if (this.plugin.getSettings().getCrossServer().isEnabled()) {
                this.fireEvent(event -> {
                    this.performTransactions();
                    this.plugin.getBroker().ifPresent(b -> Message.builder().type(Message.MessageType.TELEPORT_TO_NETWORKED_POSITION).target(username.name(), Message.TargetType.PLAYER).build().send((Broker)b, this.executor));
                });
                return;
            }
            throw new TeleportationException(TeleportationException.Type.TARGET_NOT_FOUND, this.plugin);
        }
        this.fireEvent(event -> {
            this.performTransactions();
            if (this.updateLastPosition && this.canReturnToWorld(teleporter)) {
                this.plugin.getDatabase().setLastPosition(teleporter, teleporter.getPosition());
            }
            Position target = (Position)this.target;
            if (!this.plugin.getSettings().getCrossServer().isEnabled() || target.getServer().equals(this.plugin.getServerName())) {
                teleporter.teleportLocally(target, this.async);
                this.displayTeleportingComplete(teleporter);
                teleporter.handleInvulnerability();
                return;
            }
            this.plugin.getDatabase().setCurrentTeleport(teleporter, this);
            this.plugin.getBroker().ifPresent(b -> ((PluginMessageBroker)b).changeServer(teleporter, target.getServer()));
        });
    }

    private void executeRemote() throws TeleportationException {
        Username teleporter = (Username)this.teleporter;
        if (!this.plugin.getSettings().getCrossServer().isEnabled()) {
            throw new TeleportationException(TeleportationException.Type.TELEPORTER_NOT_FOUND, this.plugin);
        }
        this.fireEvent(event -> this.plugin.getBroker().ifPresent(b -> {
            this.performTransactions();
            Target patt0$temp = this.target;
            if (patt0$temp instanceof Username) {
                Username username = (Username)patt0$temp;
                Message.builder().type(Message.MessageType.TELEPORT_TO_NETWORKED_USER).target(teleporter.name(), Message.TargetType.PLAYER).payload(Payload.string(username.name())).build().send((Broker)b, this.executor);
                return;
            }
            Message.builder().type(Message.MessageType.TELEPORT_TO_POSITION).target(teleporter.name(), Message.TargetType.PLAYER).payload(Payload.position((Position)this.target)).build().send((Broker)b, this.executor);
        }));
    }

    private boolean canReturnToWorld(@NotNull OnlineUser user) {
        return this.plugin.getSettings().getGeneral().getBackCommand().canReturnToWorld(user.getPosition().getWorld());
    }

    @NotNull
    private Optional<OnlineUser> resolveLocalTeleporter() throws TeleportationException {
        Teleportable teleportable = this.teleporter;
        if (teleportable instanceof Username) {
            Username username = (Username)teleportable;
            return username.findLocally(this.plugin);
        }
        return Optional.of((OnlineUser)this.teleporter);
    }

    public void displayTeleportingComplete(@NotNull OnlineUser teleporter) {
        this.plugin.getLocales().getLocale("teleporting_complete").ifPresent(teleporter::sendMessage);
        this.plugin.getSettings().getGeneral().getSoundEffects().get(Settings.SoundEffectAction.TELEPORTATION_COMPLETE).ifPresent(teleporter::playSound);
    }

    private void fireEvent(@NotNull ThrowingConsumer<ITeleportEvent> afterFired) {
        this.plugin.fireEvent(this.plugin.getTeleportEvent(this), afterFired);
    }

    protected void validateTransactions() throws TeleportationException {
        if (this.actions.stream().map(action -> this.plugin.validateTransaction(this.executor, (TransactionResolver.Action)((Object)action))).anyMatch(result -> result == false)) {
            throw new TeleportationException(TeleportationException.Type.TRANSACTION_FAILED, this.plugin);
        }
    }

    private void performTransactions() {
        this.actions.forEach(action -> this.plugin.performTransaction(this.executor, (TransactionResolver.Action)((Object)action)));
    }

    @Generated
    public HuskHomes getPlugin() {
        return this.plugin;
    }

    @Override
    @Generated
    public OnlineUser getExecutor() {
        return this.executor;
    }

    @Generated
    public Teleportable getTeleporter() {
        return this.teleporter;
    }

    @Generated
    public Target getTarget() {
        return this.target;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public List<TransactionResolver.Action> getActions() {
        return this.actions;
    }

    @Generated
    public boolean isAsync() {
        return this.async;
    }

    @Generated
    public boolean isUpdateLastPosition() {
        return this.updateLastPosition;
    }

    public static enum Type {
        TELEPORT(0),
        RESPAWN(1),
        BACK(2),
        RANDOM_TELEPORT(3);

        private final int typeId;

        public static Optional<Type> getTeleportType(int typeId) {
            return Arrays.stream(Type.values()).filter(type -> type.getTypeId() == typeId).findFirst();
        }

        @Generated
        public int getTypeId() {
            return this.typeId;
        }

        @Generated
        private Type(int typeId) {
            this.typeId = typeId;
        }
    }
}

