/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.position;

import java.util.UUID;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.user.CommandUser;

public class Warp
extends SavedPosition {
    private static final String USE_PERMISSION_FORMAT = "huskhomes.warp.%s";
    private static final String USE_PERMISSION_WILDCARD = "huskhomes.warp.*";

    private Warp(double x, double y, double z, float yaw, float pitch, @NotNull World world, @NotNull String server, @NotNull PositionMeta positionMeta, @NotNull UUID uuid) {
        super(x, y, z, yaw, pitch, world, server, positionMeta, uuid);
    }

    private Warp(@NotNull Position position, @NotNull PositionMeta meta) {
        super(position, meta);
    }

    @NotNull
    public static Warp from(double x, double y, double z, float yaw, float pitch, @NotNull World world, @NotNull String server, @NotNull PositionMeta positionMeta, @NotNull UUID uuid) {
        return new Warp(x, y, z, yaw, pitch, world, server, positionMeta, uuid);
    }

    @NotNull
    public static Warp from(@NotNull Position position, @NotNull PositionMeta meta) {
        return new Warp(position, meta);
    }

    @NotNull
    public Warp copy() {
        return new Warp(this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch(), this.getWorld(), this.getServer(), this.getMeta().copy(), this.getUuid());
    }

    @NotNull
    public static String getPermission(@NotNull String warpName) {
        return USE_PERMISSION_FORMAT.formatted(warpName);
    }

    public boolean hasPermission(@NotNull CommandUser user) {
        return Warp.hasPermission(user, this.getName());
    }

    public static boolean hasPermission(@NotNull CommandUser user, @NotNull String warpName) {
        String warpPermission = Warp.getPermission(warpName);
        if (user.isPermissionSet(warpPermission)) {
            return user.hasPermission(warpPermission);
        }
        return user.hasPermission(USE_PERMISSION_WILDCARD);
    }
}

