/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.listener;

import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.listener.EventListener;
import org.bukkit.Location;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class BukkitEventListener
extends EventListener
implements Listener {
    protected boolean usePaperEvents = false;

    public BukkitEventListener(@NotNull BukkitHuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void register() {
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.getPlugin().getOnlineUserMap().remove(event.getPlayer().getUniqueId());
        super.handlePlayerJoin(this.getPlugin().getOnlineUser(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLeave(PlayerQuitEvent event) {
        super.handlePlayerLeave(this.getPlugin().getOnlineUser(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        super.handlePlayerDeath(this.getPlugin().getOnlineUser(event.getEntity()));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.usePaperEvents) {
            return;
        }
        this.getPlugin().getOnlineUserMap().remove(event.getPlayer().getUniqueId());
        super.handlePlayerRespawn(this.getPlugin().getOnlineUser(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.COMMAND && event.getCause() != PlayerTeleportEvent.TeleportCause.PLUGIN) {
            return;
        }
        this.handlePlayerTeleport(this.getPlugin().getOnlineUser(player), BukkitHuskHomes.Adapter.adapt(event.getFrom(), this.getPlugin().getServerName()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerUpdateRespawnLocation(PlayerInteractEvent event) {
        Settings.CrossServerSettings crossServer = this.getPlugin().getSettings().getCrossServer();
        if (this.usePaperEvents || !crossServer.isEnabled() && crossServer.isGlobalRespawning()) {
            return;
        }
        if (event.getClickedBlock() == null || !(event.getClickedBlock().getBlockData() instanceof Bed) && !(event.getClickedBlock().getBlockData() instanceof RespawnAnchor)) {
            return;
        }
        Location location = event.getPlayer().getBedSpawnLocation();
        if (location == null) {
            return;
        }
        this.handlePlayerUpdateSpawnPoint(this.getPlugin().getOnlineUser(event.getPlayer()), BukkitHuskHomes.Adapter.adapt(location, this.getPlugin().getServerName()));
    }

    @Override
    @NotNull
    protected BukkitHuskHomes getPlugin() {
        return (BukkitHuskHomes)super.getPlugin();
    }
}

