/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.minedown.adventure;

import net.kyori.adventure.text.Component;
import net.william278.huskhomes.libraries.minedown.adventure.MineDownParser;

public class MineDown {
    public static final String FONT_PREFIX = "font=";
    public static final String COLOR_PREFIX = "color=";
    public static final String FORMAT_PREFIX = "format=";
    public static final String HOVER_PREFIX = "hover=";
    public static final String INSERTION_PREFIX = "insert=";
    private String message;
    private final MineDownParser parser = new MineDownParser();
    private Component components = null;

    public MineDown(String message) {
        this.message = message;
    }

    public static Component parse(String message) {
        return new MineDown(message).toComponent();
    }

    public Component toComponent() {
        if (this.components() == null) {
            String message = this.message();
            this.components = this.parser().parse(message).build();
        }
        return this.components();
    }

    private void reset() {
        this.components = null;
    }

    @Deprecated
    public MineDown translateLegacyColors(boolean translateLegacyColors) {
        this.reset();
        this.parser().translateLegacyColors(translateLegacyColors);
        return this;
    }

    public MineDown urlDetection(boolean enabled) {
        this.reset();
        this.parser().urlDetection(enabled);
        return this;
    }

    public MineDown autoAddUrlPrefix(boolean enabled) {
        this.reset();
        this.parser().autoAddUrlPrefix(enabled);
        return this;
    }

    public MineDown urlHoverText(String text) {
        this.reset();
        this.parser().urlHoverText(text);
        return this;
    }

    public MineDown hoverTextWidth(int hoverTextWidth) {
        this.reset();
        this.parser().hoverTextWidth(hoverTextWidth);
        return this;
    }

    public MineDown enable(MineDownParser.Option option) {
        this.reset();
        this.parser().enable(option);
        return this;
    }

    public MineDown disable(MineDownParser.Option option) {
        this.reset();
        this.parser().disable(option);
        return this;
    }

    public MineDown filter(MineDownParser.Option option) {
        this.reset();
        this.parser().filter(option);
        return this;
    }

    public MineDown unfilter(MineDownParser.Option option) {
        this.reset();
        this.parser().unfilter(option);
        return this;
    }

    public MineDown colorChar(char colorChar) {
        this.reset();
        this.parser().colorChar(colorChar);
        return this;
    }

    public String message() {
        return this.message;
    }

    public MineDown message(String message) {
        this.message = message;
        this.reset();
        return this;
    }

    public MineDownParser parser() {
        return this.parser;
    }

    protected Component components() {
        return this.components;
    }

    public MineDown copy() {
        return new MineDown(this.message()).copy(this);
    }

    public MineDown copy(MineDown from) {
        this.parser().copy(from.parser());
        return this;
    }

    public static String escape(String string) {
        return new MineDown(string).parser().escape(string);
    }
}

