/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.InGameCommand;
import net.william278.huskhomes.command.UserListTabCompletable;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.manager.RequestsManager;
import net.william278.huskhomes.teleport.TeleportRequest;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;

public class TpRequestCommand
extends InGameCommand
implements UserListTabCompletable {
    private final TeleportRequest.Type requestType;

    protected TpRequestCommand(@NotNull HuskHomes plugin, @NotNull TeleportRequest.Type type) {
        super(List.of(type == TeleportRequest.Type.TPA ? "tpa" : "tpahere"), "<player>", plugin);
        this.requestType = type;
    }

    @Override
    public void execute(@NotNull OnlineUser onlineUser, @NotNull String[] args) {
        RequestsManager manager = this.plugin.getManager().requests();
        if (manager.isIgnoringRequests(onlineUser)) {
            this.plugin.getLocales().getLocale("error_ignoring_teleport_requests").ifPresent(onlineUser::sendMessage);
            return;
        }
        Optional<String> optionalTarget = this.parseStringArg(args, 0);
        if (optionalTarget.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(onlineUser::sendMessage);
            return;
        }
        String target = optionalTarget.get();
        if (target.equalsIgnoreCase(onlineUser.getName())) {
            this.plugin.getLocales().getLocale("error_teleport_request_self").ifPresent(onlineUser::sendMessage);
            return;
        }
        if (!this.plugin.validateTransaction(onlineUser, TransactionResolver.Action.SEND_TELEPORT_REQUEST)) {
            return;
        }
        try {
            manager.sendTeleportRequest(onlineUser, target, this.requestType, () -> this.handleSuccessfulRequest(onlineUser, target));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLocales().getLocale("error_player_not_found", target).ifPresent(onlineUser::sendMessage);
        }
    }

    private void handleSuccessfulRequest(@NotNull OnlineUser onlineUser, @NotNull String target) {
        this.plugin.performTransaction(onlineUser, TransactionResolver.Action.SEND_TELEPORT_REQUEST);
        this.plugin.getLocales().getLocale((this.requestType == TeleportRequest.Type.TPA ? "tpa" : "tpahere") + "_request_sent", target).ifPresent(onlineUser::sendMessage);
    }
}

