/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.ListCommand;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.paginedown.PaginatedList;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;

public class HomeListCommand
extends ListCommand {
    protected HomeListCommand(@NotNull HuskHomes plugin) {
        super(List.of("homelist", "homes"), "[player] [page]", plugin);
        this.addAdditionalPermissions(Map.of("other", true));
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional<String> optional;
        if (args.length > 0) {
            optional = this.parseStringArg(args, 0);
        } else if (executor instanceof OnlineUser) {
            OnlineUser user = (OnlineUser)executor;
            optional = Optional.of(user.getName());
        } else {
            optional = Optional.empty();
        }
        Optional<String> homeOwner = optional;
        int pageNumber = this.parseIntArg(args, args.length > 1 ? 1 : 0).orElse(1);
        if (homeOwner.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return;
        }
        this.showHomeList(executor, homeOwner.get(), pageNumber);
    }

    protected void showHomeList(@NotNull CommandUser executor, @NotNull String homeOwner, int pageNumber) {
        User user;
        int page;
        Optional<User> targetUser = this.plugin.getDatabase().getUser(homeOwner).map(SavedUser::getUser);
        if (targetUser.isEmpty()) {
            Optional<Integer> pageNumberArg = this.parseIntArg(new String[]{homeOwner}, 0);
            if (pageNumberArg.isEmpty() || !(executor instanceof OnlineUser)) {
                this.plugin.getLocales().getLocale("error_player_not_found", homeOwner).ifPresent(executor::sendMessage);
                return;
            }
            OnlineUser onlineUser = (OnlineUser)executor;
            page = pageNumberArg.get();
            user = onlineUser;
        } else {
            user = targetUser.get();
            page = pageNumber;
        }
        if (executor instanceof OnlineUser) {
            OnlineUser onlineUser = (OnlineUser)executor;
            if (!user.getUuid().equals(onlineUser.getUuid()) && !executor.hasPermission(this.getPermission("other"))) {
                this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
                return;
            }
        }
        if (this.cachedLists.containsKey(user.getUuid())) {
            executor.sendMessage(((PaginatedList)this.cachedLists.get(user.getUuid())).getNearestValidPage(page));
            return;
        }
        List<Home> homes = this.plugin.getDatabase().getHomes(user);
        this.plugin.fireEvent(this.plugin.getViewHomeListEvent(homes, executor, false), event -> this.generateList(executor, user, event.getHomes()).ifPresent(homeList -> {
            this.cachedLists.put(user.getUuid(), homeList);
            executor.sendMessage(homeList.getNearestValidPage(page));
        }));
    }

    private Optional<PaginatedList> generateList(@NotNull CommandUser executor, @NotNull User user, @NotNull List<Home> homes) {
        if (homes.isEmpty()) {
            if (!executor.equals(user)) {
                this.plugin.getLocales().getLocale("error_no_homes_set_other", user.getName()).ifPresent(executor::sendMessage);
            } else {
                this.plugin.getLocales().getLocale("error_no_homes_set").ifPresent(executor::sendMessage);
            }
            return Optional.empty();
        }
        String homeListArguments = !executor.equals(user) ? " " + user.getName() : "";
        PaginatedList homeList = PaginatedList.of(homes.stream().map(home -> this.plugin.getLocales().getRawLocale("home_list_item", Locales.escapeText(home.getName()), home.getSafeIdentifier(), home.isPublic() ? this.plugin.getLocales().getRawLocale("home_is_public").orElse("Public") : this.plugin.getLocales().getRawLocale("home_is_private").orElse("Private"), home.getMeta().getDescription().isBlank() ? this.plugin.getLocales().getNone() : Locales.escapeText(home.getMeta().getDescription())).orElse(home.getName())).sorted().collect(Collectors.toList()), this.plugin.getLocales().getBaseList(this.plugin.getSettings().getGeneral().getListItemsPerPage()).setHeaderFormat(this.plugin.getLocales().getRawLocale("home_list_page_title", user.getName(), "%first_item_on_page_index%", "%last_item_on_page_index%", "%total_items%").orElse("")).setCommand("/huskhomes:homelist" + homeListArguments).build());
        return Optional.of(homeList);
    }
}

