/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.config;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.TestOnly;
import net.william278.huskhomes.libraries.commons.text.StringEscapeUtils;
import net.william278.huskhomes.libraries.configlib.Configuration;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.libraries.paginedown.ListOptions;

@Configuration
public class Locales {
    static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      HuskHomes Locales       \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 See plugin about menu for international locale credits\n\u2523\u2578 Formatted in MineDown: https://github.com/WiIIiam278/MineDown\n\u2517\u2578 Translate HuskHomes: https://william278.net/docs/huskhomes/translations";
    protected static final String DEFAULT_LOCALE = "en-gb";
    private Map<String, String> locales = Maps.newTreeMap();

    @TestOnly
    @NotNull
    public Map<String, String> getRawLocales() {
        return this.locales;
    }

    public Optional<String> getRawLocale(@NotNull String localeId) {
        return Optional.ofNullable(this.locales.get(localeId)).map(StringEscapeUtils::unescapeJava);
    }

    public Optional<String> getRawLocale(@NotNull String localeId, String ... replacements) {
        return this.getRawLocale(localeId).map(locale -> this.applyReplacements((String)locale, replacements));
    }

    public Optional<MineDown> getLocale(@NotNull String localeId) {
        return this.getRawLocale(localeId).map(this::format);
    }

    public Optional<MineDown> getLocale(@NotNull String localeId, String ... replacements) {
        return this.getRawLocale(localeId, (String[])Arrays.stream(replacements).map(Locales::escapeText).toArray(String[]::new)).map(this::format);
    }

    @NotNull
    public MineDown format(@NotNull String text) {
        return new MineDown(text);
    }

    @NotNull
    private String applyReplacements(@NotNull String rawLocale, String ... replacements) {
        int replacementIndexer = 1;
        for (String replacement : replacements) {
            String replacementString = "%" + replacementIndexer + "%";
            rawLocale = rawLocale.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        return rawLocale;
    }

    @NotNull
    public static String escapeText(@NotNull String string) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean isEvent;
            char c = string.charAt(i);
            boolean isEscape = c == '\\';
            boolean isColorCode = i + 1 < string.length() && (c == '\u00a7' || c == '&');
            boolean bl = isEvent = c == '[' || c == ']' || c == '(' || c == ')';
            if (isEscape || isColorCode || isEvent) {
                value.append('\\');
            }
            value.append(c);
        }
        return value.toString();
    }

    @NotNull
    public String truncateText(@NotNull String string, int truncateAfter) {
        if (string.isBlank()) {
            return string;
        }
        return string.length() > truncateAfter ? string.substring(0, truncateAfter) + "\u2026" : string;
    }

    @NotNull
    public String getNotApplicable() {
        return this.getRawLocale("not_applicable").orElse("N/A");
    }

    @NotNull
    public String getListJoiner() {
        return this.getRawLocale("list_separator").orElse(", ");
    }

    @NotNull
    public String getNone() {
        return this.getRawLocale("none").orElse("(none)");
    }

    @NotNull
    public ListOptions.Builder getBaseList(int itemsPerPage) {
        return new ListOptions.Builder().setFooterFormat(this.getRawLocale("list_footer", "%previous_page_button%", "%current_page%", "%total_pages%", "%next_page_button%", "%page_jumpers%").orElse("")).setNextButtonFormat(this.getRawLocale("list_next_page_button", "%next_page_index%", "%command%").orElse("")).setPreviousButtonFormat(this.getRawLocale("list_previous_page_button", "%previous_page_index%", "%command%").orElse("")).setPageJumpersFormat(this.getRawLocale("list_page_jumpers", "%page_jump_buttons%").orElse("")).setPageJumperPageFormat(this.getRawLocale("list_page_jumper_button", "%target_page_index%", "%command%").orElse("")).setPageJumperCurrentPageFormat(this.getRawLocale("list_page_jumper_current_page", "%current_page%").orElse("")).setPageJumperPageSeparator(this.getRawLocale("list_page_jumper_separator").orElse("")).setPageJumperGroupSeparator(this.getRawLocale("list_page_jumper_group_separator").orElse("")).setItemSeparator(this.getRawLocale("list_item_divider").orElse(" ")).setItemsPerPage(itemsPerPage).setEscapeItemsMineDown(false).setSpaceAfterHeader(false).setSpaceBeforeFooter(false);
    }

    @Generated
    private Locales() {
    }

    public static enum DisplaySlot {
        CHAT,
        ACTION_BAR,
        SUBTITLE,
        TITLE,
        NONE;

    }
}

