/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.PluginMessageBroker;
import net.william278.huskhomes.network.RedisBroker;

public interface BrokerProvider {
    public Optional<Broker> getBroker();

    public void setBroker(@NotNull Broker var1);

    public void closeBroker();

    public void setupPluginMessagingChannels();

    default public void loadBroker() {
        if (!this.getPlugin().getSettings().getCrossServer().isEnabled()) {
            return;
        }
        switch (this.getPlugin().getSettings().getCrossServer().getBrokerType()) {
            case REDIS: {
                this.setBroker(new RedisBroker(this.getPlugin()));
                break;
            }
            case PLUGIN_MESSAGE: {
                this.setBroker(new PluginMessageBroker(this.getPlugin()));
            }
        }
        this.getBroker().ifPresent(Broker::initialize);
    }

    @NotNull
    public HuskHomes getPlugin();
}

