/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.user;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.libraries.annotations.ApiStatus;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.paperlib.PaperLib;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BukkitUser
extends OnlineUser {
    private static final String VANISHED_META_KEY = "vanished";
    private final NamespacedKey INVULNERABLE_KEY;
    private final Player bukkitPlayer;

    private BukkitUser(@NotNull Player bukkitPlayer, @NotNull BukkitHuskHomes plugin) {
        super(bukkitPlayer.getUniqueId(), bukkitPlayer.getName(), plugin);
        this.INVULNERABLE_KEY = new NamespacedKey((Plugin)((BukkitHuskHomes)this.plugin), "invulnerable");
        this.bukkitPlayer = bukkitPlayer;
    }

    @NotNull
    @ApiStatus.Internal
    public static BukkitUser adapt(@NotNull Player player, @NotNull BukkitHuskHomes plugin) {
        return new BukkitUser(player, plugin);
    }

    @NotNull
    public Player getPlayer() {
        return this.bukkitPlayer;
    }

    @Override
    public Position getPosition() {
        return BukkitHuskHomes.Adapter.adapt(this.bukkitPlayer.getLocation(), this.plugin.getServerName());
    }

    @Override
    public Optional<Position> getBedSpawnPosition() {
        return Optional.ofNullable(this.bukkitPlayer.getBedSpawnLocation()).map(loc -> BukkitHuskHomes.Adapter.adapt(loc, this.plugin.getServerName()));
    }

    @Override
    public double getHealth() {
        return this.bukkitPlayer.getHealth();
    }

    @Override
    public boolean isPermissionSet(@NotNull String node) {
        return this.bukkitPlayer.isPermissionSet(node);
    }

    @Override
    public boolean hasPermission(@NotNull String node) {
        return this.bukkitPlayer.hasPermission(node);
    }

    @Override
    @NotNull
    public Map<String, Boolean> getPermissions() {
        return this.bukkitPlayer.getEffectivePermissions().stream().collect(Collectors.toMap(PermissionAttachmentInfo::getPermission, PermissionAttachmentInfo::getValue, (a, b) -> b));
    }

    @Override
    public CompletableFuture<Void> dismount() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.plugin.runSync(() -> {
            this.bukkitPlayer.leaveVehicle();
            this.bukkitPlayer.eject();
            future.complete(null);
        }, this);
        return future;
    }

    @Override
    public void teleportLocally(@NotNull Location target, boolean async) throws TeleportationException {
        org.bukkit.Location location = BukkitHuskHomes.Adapter.adapt(target);
        if (location.getWorld() == null) {
            throw new TeleportationException(TeleportationException.Type.WORLD_NOT_FOUND, this.plugin);
        }
        if (!location.getWorld().getWorldBorder().isInside(location)) {
            throw new TeleportationException(TeleportationException.Type.ILLEGAL_TARGET_COORDINATES, this.plugin);
        }
        this.plugin.runSync(() -> {
            this.bukkitPlayer.leaveVehicle();
            this.bukkitPlayer.eject();
            if (async || ((BukkitHuskHomes)this.plugin).getScheduler().isUsingFolia()) {
                PaperLib.teleportAsync((Entity)this.bukkitPlayer, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
                return;
            }
            this.bukkitPlayer.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }, this);
    }

    @Override
    public boolean isMoving() {
        return this.bukkitPlayer.getVelocity().length() >= 0.1;
    }

    @Override
    public void sendPluginMessage(byte[] message) {
        this.bukkitPlayer.sendPluginMessage((Plugin)((BukkitHuskHomes)this.plugin), "BungeeCord", message);
    }

    @Override
    public boolean isVanished() {
        return this.bukkitPlayer.hasMetadata(VANISHED_META_KEY) && this.bukkitPlayer.getMetadata(VANISHED_META_KEY).stream().map(MetadataValue::asBoolean).findFirst().orElse(false) != false;
    }

    @Override
    public boolean hasInvulnerability() {
        return this.markedAsInvulnerable || this.bukkitPlayer.getPersistentDataContainer().has(this.INVULNERABLE_KEY, PersistentDataType.INTEGER);
    }

    @Override
    public void handleInvulnerability() {
        long invulnerableTicks = 20L * (long)this.plugin.getSettings().getGeneral().getTeleportInvulnerabilityTime();
        if (invulnerableTicks <= 0L) {
            return;
        }
        this.markedAsInvulnerable = true;
        this.bukkitPlayer.getPersistentDataContainer().set(this.INVULNERABLE_KEY, PersistentDataType.INTEGER, (Object)1);
        this.bukkitPlayer.setInvulnerable(true);
        this.plugin.runSyncDelayed(this::removeInvulnerabilityIfPermitted, this, invulnerableTicks);
    }

    @Override
    public void removeInvulnerabilityIfPermitted() {
        if (this.hasInvulnerability()) {
            this.bukkitPlayer.setInvulnerable(false);
        }
        this.bukkitPlayer.getPersistentDataContainer().remove(this.INVULNERABLE_KEY);
        this.markedAsInvulnerable = false;
    }

    @Override
    public boolean isValid() {
        return this.getHealth() > 0.0;
    }
}

