/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.manager;

import java.time.Instant;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.TeleportRequest;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;

public class RequestsManager {
    private final HuskHomes plugin;
    private final Map<UUID, Deque<TeleportRequest>> requests;

    public RequestsManager(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
        this.requests = new ConcurrentHashMap<UUID, Deque<TeleportRequest>>();
    }

    public boolean isIgnoringRequests(@NotNull User user) {
        return this.plugin.getSavedUser(user).map(SavedUser::isIgnoringTeleports).orElse(false);
    }

    public void addTeleportRequest(@NotNull TeleportRequest request, @NotNull User recipient) {
        this.requests.computeIfAbsent(recipient.getUuid(), uuid -> new ConcurrentLinkedDeque()).addFirst(request);
    }

    public void removeTeleportRequest(@NotNull String requesterName, @NotNull User recipient) {
        this.requests.computeIfPresent(recipient.getUuid(), (uuid, requests) -> {
            requests.removeIf(teleportRequest -> teleportRequest.getRequesterName().equalsIgnoreCase(requesterName));
            return requests.isEmpty() ? null : requests;
        });
    }

    public Optional<TeleportRequest> getLastTeleportRequest(@NotNull User recipient) {
        return ((Deque)this.requests.getOrDefault(recipient.getUuid(), new ConcurrentLinkedDeque())).stream().findFirst();
    }

    public Optional<TeleportRequest> getTeleportRequest(@NotNull String requesterName, @NotNull User recipient) {
        return ((Deque)this.requests.getOrDefault(recipient.getUuid(), new ConcurrentLinkedDeque())).stream().filter(request -> request.getRequesterName().equalsIgnoreCase(requesterName)).filter(request -> !request.hasExpired()).findFirst().or(() -> ((Deque)this.requests.getOrDefault(recipient.getUuid(), new ConcurrentLinkedDeque())).stream().filter(request -> request.getRequesterName().equalsIgnoreCase(requesterName)).findFirst());
    }

    public void sendTeleportAllRequest(@NotNull OnlineUser requester) {
        long expiry = Instant.now().getEpochSecond() + (long)this.plugin.getSettings().getGeneral().getTeleportRequestExpiryTime();
        for (OnlineUser onlineUser : this.plugin.getOnlineUsers()) {
            TeleportRequest request = new TeleportRequest(requester, TeleportRequest.Type.TPA_HERE, expiry);
            if (onlineUser.equals(requester)) continue;
            request.setRecipientName(onlineUser.getName());
            this.sendLocalTeleportRequest(request, onlineUser);
        }
        TeleportRequest request = new TeleportRequest(requester, TeleportRequest.Type.TPA_HERE, expiry);
        this.plugin.getBroker().ifPresent(b -> Message.builder().type(Message.MessageType.TELEPORT_REQUEST).payload(Payload.teleportRequest(request)).target("ALL", Message.TargetType.PLAYER).build().send((Broker)b, requester));
    }

    public void sendTeleportRequest(@NotNull OnlineUser requester, @NotNull String targetUser, @NotNull TeleportRequest.Type type, @NotNull Runnable callback) throws IllegalArgumentException {
        Optional<OnlineUser> localTarget;
        long expiry = Instant.now().getEpochSecond() + (long)this.plugin.getSettings().getGeneral().getTeleportRequestExpiryTime();
        TeleportRequest request = new TeleportRequest(requester, type, expiry);
        request.setRecipientName(targetUser);
        Optional<OnlineUser> optional = localTarget = this.plugin.isUserOnlineGlobally(targetUser) ? this.plugin.getOnlineUserExact(targetUser) : this.plugin.getOnlineUser(targetUser);
        if (localTarget.isPresent()) {
            if (localTarget.get().equals(requester)) {
                throw new IllegalArgumentException("Cannot send a teleport request to yourself");
            }
            if (localTarget.get().isVanished()) {
                throw new IllegalArgumentException("Cannot send a teleport request to a vanished player");
            }
            this.plugin.fireEvent(this.plugin.getSendTeleportRequestEvent(requester, request), event -> {
                this.sendLocalTeleportRequest(request, (OnlineUser)localTarget.get());
                callback.run();
            });
            return;
        }
        if (this.plugin.getSettings().getCrossServer().isEnabled()) {
            this.plugin.fireEvent(this.plugin.getSendTeleportRequestEvent(requester, request), event -> {
                this.plugin.getBroker().ifPresent(b -> Message.builder().type(Message.MessageType.TELEPORT_REQUEST).payload(Payload.teleportRequest(request)).target(targetUser, Message.TargetType.PLAYER).build().send((Broker)b, requester));
                callback.run();
            });
            return;
        }
        throw new IllegalArgumentException("Player not found");
    }

    public void sendLocalTeleportRequest(@NotNull TeleportRequest request, @NotNull OnlineUser recipient) {
        request.setRecipientName(recipient.getName());
        if (this.isIgnoringRequests(recipient) || recipient.isVanished()) {
            request.setStatus(TeleportRequest.Status.IGNORED);
            return;
        }
        Optional<TeleportRequest> existingRequest = this.getTeleportRequest(request.getRequesterName(), recipient);
        if (existingRequest.isPresent() && existingRequest.get().getType() == request.getType() && !existingRequest.get().hasExpired()) {
            return;
        }
        this.plugin.fireEvent(this.plugin.getReceiveTeleportRequestEvent(recipient, request), event -> {
            this.addTeleportRequest(request, recipient);
            this.plugin.getLocales().getLocale((request.getType() == TeleportRequest.Type.TPA ? "tpa" : "tpahere") + "_request_received", request.getRequesterName()).ifPresent(recipient::sendMessage);
            this.plugin.getLocales().getLocale("teleport_request_buttons", request.getRequesterName()).ifPresent(recipient::sendMessage);
            this.plugin.getSettings().getGeneral().getSoundEffects().get(Settings.SoundEffectAction.TELEPORT_REQUEST_RECEIVED).ifPresent(recipient::playSound);
        });
    }

    public void respondToTeleportRequestBySenderName(@NotNull OnlineUser recipient, @NotNull String senderName, boolean accepted) {
        if (this.isIgnoringRequests(recipient)) {
            this.plugin.getLocales().getLocale("error_ignoring_teleport_requests").ifPresent(recipient::sendMessage);
            return;
        }
        Optional<TeleportRequest> namedRequest = this.getTeleportRequest(senderName, recipient);
        if (namedRequest.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_teleport_request", senderName).ifPresent(recipient::sendMessage);
            return;
        }
        this.handleRequestResponse(namedRequest.get(), recipient, accepted);
    }

    public void respondToTeleportRequest(@NotNull OnlineUser recipient, boolean accepted) {
        if (this.isIgnoringRequests(recipient)) {
            this.plugin.getLocales().getLocale("error_ignoring_teleport_requests").ifPresent(recipient::sendMessage);
            return;
        }
        Optional<TeleportRequest> lastRequest = this.getLastTeleportRequest(recipient);
        if (lastRequest.isEmpty()) {
            this.plugin.getLocales().getLocale("error_no_teleport_requests").ifPresent(recipient::sendMessage);
            return;
        }
        if (accepted && !this.plugin.validateTransaction(recipient, TransactionResolver.Action.ACCEPT_TELEPORT_REQUEST)) {
            return;
        }
        this.handleRequestResponse(lastRequest.get(), recipient, accepted);
    }

    private void handleRequestResponse(@NotNull TeleportRequest request, @NotNull OnlineUser recipient, boolean accepted) {
        this.removeTeleportRequest(request.getRequesterName(), recipient);
        if (request.hasExpired()) {
            this.plugin.getLocales().getLocale("error_teleport_request_expired").ifPresent(recipient::sendMessage);
            return;
        }
        request.setStatus(accepted ? TeleportRequest.Status.ACCEPTED : TeleportRequest.Status.DECLINED);
        this.plugin.fireEvent(this.plugin.getReplyTeleportRequestEvent(recipient, request), event -> {
            Optional<OnlineUser> localRequester;
            this.plugin.getLocales().getLocale("teleport_request_" + (accepted ? "accepted" : "declined") + "_confirmation", request.getRequesterName()).ifPresent(recipient::sendMessage);
            if (accepted && request.getType() == TeleportRequest.Type.TPA && this.plugin.getSettings().getGeneral().isStrictTpaRequests()) {
                request.setRecipientPosition(recipient.getPosition());
            }
            if ((localRequester = this.plugin.getOnlineUserExact(request.getRequesterName())).isPresent()) {
                this.handleLocalRequestResponse(localRequester.get(), request);
            } else if (this.plugin.getSettings().getCrossServer().isEnabled()) {
                this.plugin.getBroker().ifPresent(b -> Message.builder().type(Message.MessageType.TELEPORT_REQUEST_RESPONSE).payload(Payload.teleportRequest(request)).target(request.getRequesterName(), Message.TargetType.PLAYER).build().send((Broker)b, recipient));
            } else {
                this.plugin.getLocales().getLocale("error_teleport_request_sender_not_online").ifPresent(recipient::sendMessage);
                return;
            }
            if (accepted && request.getType() == TeleportRequest.Type.TPA_HERE) {
                TeleportBuilder builder = Teleport.builder(this.plugin).actions(TransactionResolver.Action.ACCEPT_TELEPORT_REQUEST).teleporter(recipient);
                if (this.plugin.getSettings().getGeneral().isStrictTpaHereRequests()) {
                    builder.target(request.getRequesterPosition());
                } else {
                    builder.target(request.getRequesterName());
                }
                builder.buildAndComplete(true, new String[0]);
            }
        });
    }

    public void handleLocalRequestResponse(@NotNull OnlineUser requester, @NotNull TeleportRequest request) {
        if (request.getStatus() == TeleportRequest.Status.IGNORED) {
            this.plugin.getLocales().getLocale("error_player_not_found", request.getRecipientName()).ifPresent(requester::sendMessage);
            return;
        }
        boolean accepted = request.getStatus() == TeleportRequest.Status.ACCEPTED;
        this.plugin.getLocales().getLocale("teleport_request_" + (accepted ? "accepted" : "declined"), request.getRecipientName()).ifPresent(requester::sendMessage);
        if (accepted && request.getType() == TeleportRequest.Type.TPA) {
            TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(requester).actions(TransactionResolver.Action.ACCEPT_TELEPORT_REQUEST);
            if (this.plugin.getSettings().getGeneral().isStrictTpaRequests() && request.getRecipientPosition() != null) {
                builder.target(request.getRecipientPosition());
            } else {
                builder.target(request.getRecipientName());
            }
            builder.buildAndComplete(true, new String[0]);
        }
    }
}

