/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.desertwell.util;

import java.util.Arrays;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.william278.huskhomes.libraries.annotations.NotNull;

public class Version
implements Comparable<Version> {
    public final String VERSION_DELIMITER = ".";
    public static final String META_DELIMITER = "-";
    private int[] versions = new int[0];
    @NotNull
    private String metadata = "";
    @NotNull
    private String metaSeparator = "";

    protected Version() {
    }

    private Version(@NotNull String version, @NotNull String metaDelimiter) {
        this.parse(version, metaDelimiter);
        this.metaSeparator = metaDelimiter;
    }

    @NotNull
    public static Version fromString(@NotNull String version, @NotNull String metaDelimiter) {
        return new Version(version, metaDelimiter);
    }

    @NotNull
    public static Version fromString(@NotNull String versionString) {
        return new Version(versionString, META_DELIMITER);
    }

    private void parse(@NotNull String version, @NotNull String metaDelimiter) {
        int metaIndex = version.indexOf(metaDelimiter);
        if (metaIndex > 0) {
            this.metadata = version.substring(metaIndex + 1);
            version = version.substring(0, metaIndex);
        }
        String[] versions = version.split(Pattern.quote("."));
        this.versions = Arrays.stream(versions).mapToInt(Integer::parseInt).toArray();
    }

    @Override
    public int compareTo(@NotNull Version other) {
        int length = Math.max(this.versions.length, other.versions.length);
        for (int i = 0; i < length; ++i) {
            int b;
            int a = i < this.versions.length ? this.versions[i] : 0;
            int n = b = i < other.versions.length ? other.versions[i] : 0;
            if (a < b) {
                return -1;
            }
            if (a <= b) continue;
            return 1;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        StringJoiner joiner = new StringJoiner(".");
        for (int version : this.versions) {
            joiner.add(String.valueOf(version));
        }
        return joiner + (String)(!this.metadata.isEmpty() ? this.metaSeparator + this.metadata : "");
    }

    @NotNull
    public String toStringWithoutMetadata() {
        StringJoiner joiner = new StringJoiner(".");
        for (int version : this.versions) {
            joiner.add(String.valueOf(version));
        }
        return joiner.toString();
    }

    public int getMajor() {
        return this.versions[0];
    }

    public int getMinor() {
        return this.versions[1];
    }

    public int getPatch() {
        return this.versions[2];
    }

    @NotNull
    public String getMetadata() {
        return this.metadata;
    }
}

