/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import lombok.Generated;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.gson.annotations.Expose;
import net.william278.huskhomes.libraries.gson.annotations.SerializedName;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.user.OnlineUser;

public class Message {
    public static final String TARGET_ALL = "ALL";
    @Expose
    @NotNull
    private MessageType type;
    @Expose
    @SerializedName(value="target_type")
    @NotNull
    private TargetType targetType;
    @Expose
    @NotNull
    private String target;
    @Expose
    @NotNull
    private Payload payload;
    @Expose
    @NotNull
    private String sender;
    @Expose
    @SerializedName(value="source_server")
    @NotNull
    private String sourceServer;

    private Message(@NotNull MessageType type, @NotNull String target, @NotNull TargetType targetType, @NotNull Payload payload) {
        this.type = type;
        this.target = target;
        this.targetType = targetType;
        this.payload = payload;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public void send(@NotNull Broker broker, @Nullable OnlineUser sender) {
        this.sender = sender != null ? sender.getName() : broker.getServer();
        this.sourceServer = broker.getServer();
        broker.send(this, sender);
    }

    @NotNull
    @Generated
    public MessageType getType() {
        return this.type;
    }

    @NotNull
    @Generated
    public TargetType getTargetType() {
        return this.targetType;
    }

    @NotNull
    @Generated
    public String getTarget() {
        return this.target;
    }

    @NotNull
    @Generated
    public Payload getPayload() {
        return this.payload;
    }

    @NotNull
    @Generated
    public String getSender() {
        return this.sender;
    }

    @NotNull
    @Generated
    public String getSourceServer() {
        return this.sourceServer;
    }

    @Generated
    public Message() {
    }

    public static enum MessageType {
        TELEPORT_TO_POSITION,
        TELEPORT_TO_NETWORKED_POSITION,
        TELEPORT_REQUEST,
        TELEPORT_TO_NETWORKED_USER,
        TELEPORT_REQUEST_RESPONSE,
        REQUEST_USER_LIST,
        UPDATE_USER_LIST,
        UPDATE_HOME,
        UPDATE_WARP,
        UPDATE_CACHES,
        REQUEST_RTP_LOCATION,
        RTP_LOCATION;

    }

    public static enum TargetType {
        SERVER("Forward"),
        PLAYER("ForwardToPlayer");

        private final String pluginMessageChannel;

        private TargetType(String pluginMessageChannel) {
            this.pluginMessageChannel = pluginMessageChannel;
        }

        @NotNull
        public String getPluginMessageChannel() {
            return this.pluginMessageChannel;
        }
    }

    public static class Builder {
        private MessageType type;
        private Payload payload = Payload.empty();
        private TargetType targetType = TargetType.PLAYER;
        private String target;

        @NotNull
        public Builder type(@NotNull MessageType type) {
            this.type = type;
            return this;
        }

        @NotNull
        public Builder payload(@NotNull Payload payload) {
            this.payload = payload;
            return this;
        }

        @NotNull
        public Builder target(@NotNull String target, @NotNull TargetType targetType) {
            this.target = target;
            this.targetType = targetType;
            return this;
        }

        @NotNull
        public Message build() {
            if (this.target == null || this.type == null) {
                throw new IllegalStateException("Message not fully built. Type: " + String.valueOf((Object)this.type) + ", Target: " + this.target);
            }
            return new Message(this.type, this.target, this.targetType, this.payload);
        }

        @Generated
        private Builder() {
        }
    }
}

