/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import java.util.logging.Level;
import lombok.Generated;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.MessageHandler;
import net.william278.huskhomes.user.OnlineUser;

public abstract class Broker
implements MessageHandler {
    protected final HuskHomes plugin;

    protected void handle(@NotNull OnlineUser receiver, @NotNull Message message) {
        if (message.getSourceServer().equals(this.getServer())) {
            return;
        }
        switch (message.getType()) {
            case REQUEST_USER_LIST: {
                this.handleRequestUserList(message, receiver);
                break;
            }
            case UPDATE_USER_LIST: {
                this.handleUpdateUserList(message);
                break;
            }
            case TELEPORT_TO_POSITION: {
                this.handleTeleportToPosition(message, receiver);
                break;
            }
            case TELEPORT_TO_NETWORKED_POSITION: {
                this.handleTeleportToNetworkedPosition(message, receiver);
                break;
            }
            case TELEPORT_TO_NETWORKED_USER: {
                this.handleTeleportToNetworkedUser(message, receiver);
                break;
            }
            case TELEPORT_REQUEST: {
                this.handleTeleportRequest(message, receiver);
                break;
            }
            case TELEPORT_REQUEST_RESPONSE: {
                this.handleTeleportRequestResponse(message, receiver);
                break;
            }
            case UPDATE_HOME: {
                this.handleUpdateHome(message, receiver);
                break;
            }
            case UPDATE_WARP: {
                this.handleUpdateWarp(message, receiver);
                break;
            }
            case UPDATE_CACHES: {
                this.handleUpdateCaches();
                break;
            }
            case RTP_LOCATION: {
                this.handleRtpLocation(message, receiver);
                break;
            }
            default: {
                this.plugin.log(Level.SEVERE, "Received unknown message type: " + String.valueOf((Object)message.getType()), new Throwable[0]);
            }
        }
    }

    public abstract void initialize() throws RuntimeException;

    protected abstract void send(@NotNull Message var1, @Nullable OnlineUser var2);

    public abstract void close();

    @NotNull
    protected String getSubChannelId() {
        return this.plugin.getKey(this.plugin.getSettings().getCrossServer().getClusterId(), this.getFormattedVersion()).asString();
    }

    protected String getServer() {
        return this.plugin.getServerName();
    }

    @NotNull
    private String getFormattedVersion() {
        return String.format("%s.%s", this.plugin.getPluginVersion().getMajor(), this.plugin.getPluginVersion().getMinor());
    }

    @Override
    @NotNull
    public Broker getBroker() {
        return this;
    }

    @Override
    @Generated
    public HuskHomes getPlugin() {
        return this.plugin;
    }

    @Generated
    protected Broker(HuskHomes plugin) {
        this.plugin = plugin;
    }

    public static enum Type {
        PLUGIN_MESSAGE("Plugin Messages"),
        REDIS("Redis");

        @NotNull
        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        @Generated
        public String getDisplayName() {
            return this.displayName;
        }
    }
}

