/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.config;

import java.util.UUID;
import lombok.Generated;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.configlib.Configuration;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;

@Configuration
public class Spawn {
    static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    Server /spawn location    \u2503\n\u2503 Edit in-game using /setspawn \u2503\n\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b";
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private String worldName;
    private String worldUuid;

    @NotNull
    public Position getPosition(@NotNull String server) {
        return Position.at(this.x, this.y, this.z, this.yaw, this.pitch, World.from(this.worldName, UUID.fromString(this.worldUuid)), server);
    }

    public Spawn(@NotNull Location location) {
        this(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), location.getWorld().getName(), location.getWorld().getUuid().toString());
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public String getWorldName() {
        return this.worldName;
    }

    @Generated
    public String getWorldUuid() {
        return this.worldUuid;
    }

    @Generated
    private Spawn() {
    }

    @Generated
    private Spawn(double x, double y, double z, float yaw, float pitch, String worldName, String worldUuid) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.worldName = worldName;
        this.worldUuid = worldUuid;
    }
}

