/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.hook.MapHook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.User;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.GenericMarker;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;

@PluginHook(name="Dynmap", register=PluginHook.Register.ON_ENABLE)
public class DynmapHook
extends MapHook {
    private static final String ICON_PATH = "/tiles/_markers_/";
    @Nullable
    private DynmapCommonAPI dynmapApi;
    @Nullable
    private MarkerSet publicHomesMarkers;
    @Nullable
    private MarkerSet warpsMarkers;

    public DynmapHook(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void load() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

            public void apiEnabled(@NotNull DynmapCommonAPI dynmapCommonAPI) {
                DynmapHook.this.dynmapApi = dynmapCommonAPI;
                Settings.MapHookSettings settings = DynmapHook.this.plugin.getSettings().getMapHook();
                if (settings.isShowPublicHomes()) {
                    DynmapHook.this.getMarkerIcon("public-home").orElseThrow();
                    DynmapHook.this.dynmapApi.getMarkerAPI().createMarkerSet(DynmapHook.this.getPublicHomesKey(), DynmapHook.this.getPublicHomesMarkerSetName(), DynmapHook.this.dynmapApi.getMarkerAPI().getMarkerIcons(), false);
                }
                if (settings.isShowWarps()) {
                    DynmapHook.this.getMarkerIcon("warp").orElseThrow();
                    DynmapHook.this.dynmapApi.getMarkerAPI().createMarkerSet(DynmapHook.this.getWarpsKey(), DynmapHook.this.getWarpsMarkerSetName(), DynmapHook.this.dynmapApi.getMarkerAPI().getMarkerIcons(), false);
                }
                DynmapHook.this.populateMap();
            }
        });
    }

    @Override
    public void addHome(@NotNull Home home) {
        if (!this.isValidPosition(home)) {
            return;
        }
        this.plugin.runSync(() -> {
            String markerId = String.valueOf(home.getOwner().getUuid()) + ":" + String.valueOf(home.getUuid());
            this.getPublicHomesMarkerSet().ifPresent(markerSet -> {
                markerSet.getMarkers().stream().filter(marker -> marker.getMarkerID().equals(markerId)).forEach(GenericMarker::deleteMarker);
                markerSet.createMarker(markerId, home.getName(), home.getWorld().getName(), home.getX(), home.getY(), home.getZ(), this.getMarkerIcon("public-home").orElseThrow(), false).setDescription(MapHook.MarkerInformationPopup.publicHome(home, "/tiles/_markers_/public-home").toHtml());
            });
        });
    }

    @Override
    public void removeHome(@NotNull Home home) {
        this.plugin.runSync(() -> {
            String markerId = String.valueOf(home.getOwner().getUuid()) + ":" + String.valueOf(home.getUuid());
            this.getPublicHomesMarkerSet().ifPresent(markerSet -> markerSet.getMarkers().stream().filter(marker -> marker.getMarkerID().equals(markerId)).forEach(GenericMarker::deleteMarker));
        });
    }

    @Override
    public void clearHomes(@NotNull User user) {
        this.plugin.runSync(() -> this.getPublicHomesMarkerSet().ifPresent(markerSet -> markerSet.getMarkers().stream().filter(marker -> marker.getMarkerID().startsWith(user.getUuid().toString())).forEach(GenericMarker::deleteMarker)));
    }

    @Override
    public void clearHomes(@NotNull String worldName) {
        this.plugin.runSync(() -> this.getPublicHomesMarkerSet().ifPresent(markerSet -> markerSet.getMarkers().stream().filter(marker -> marker.getWorld().equals(worldName)).forEach(GenericMarker::deleteMarker)));
    }

    @Override
    public void addWarp(@NotNull Warp warp) {
        if (!this.isValidPosition(warp)) {
            return;
        }
        this.plugin.runSync(() -> {
            String markerId = warp.getUuid().toString();
            this.getWarpsMarkerSet().ifPresent(markerSet -> {
                markerSet.getMarkers().stream().filter(marker -> marker.getMarkerID().equals(markerId)).forEach(GenericMarker::deleteMarker);
                markerSet.createMarker(markerId, warp.getName(), warp.getWorld().getName(), warp.getX(), warp.getY(), warp.getZ(), this.getMarkerIcon("warp").orElseThrow(), false).setDescription(MapHook.MarkerInformationPopup.warp(warp, "/tiles/_markers_/warp").toHtml());
            });
        });
    }

    @Override
    public void removeWarp(@NotNull Warp warp) {
        this.plugin.runSync(() -> {
            String markerId = warp.getUuid().toString();
            this.getWarpsMarkerSet().ifPresent(markerSet -> markerSet.getMarkers().stream().filter(marker -> marker.getMarkerID().equals(markerId)).forEach(GenericMarker::deleteMarker));
        });
    }

    @Override
    public void clearWarps() {
        this.plugin.runSync(() -> this.getWarpsMarkerSet().ifPresent(markerSet -> markerSet.getMarkers().forEach(GenericMarker::deleteMarker)));
    }

    @Override
    public void clearWarps(@NotNull String worldName) {
        this.plugin.runSync(() -> this.getWarpsMarkerSet().ifPresent(markerSet -> markerSet.getMarkers().stream().filter(marker -> marker.getWorld().equals(worldName)).forEach(GenericMarker::deleteMarker)));
    }

    private Optional<DynmapCommonAPI> getDynmap() {
        return Optional.ofNullable(this.dynmapApi);
    }

    private Optional<MarkerSet> getWarpsMarkerSet() {
        return this.getDynmap().map(api -> {
            this.warpsMarkers = api.getMarkerAPI().getMarkerSet(this.getWarpsKey());
            if (this.warpsMarkers == null) {
                this.warpsMarkers = api.getMarkerAPI().createMarkerSet(this.getWarpsKey(), this.getWarpsMarkerSetName(), api.getMarkerAPI().getMarkerIcons(), false);
            } else {
                this.warpsMarkers.setMarkerSetLabel(this.getWarpsMarkerSetName());
            }
            return this.warpsMarkers;
        });
    }

    private Optional<MarkerSet> getPublicHomesMarkerSet() {
        return this.getDynmap().map(api -> {
            this.publicHomesMarkers = api.getMarkerAPI().getMarkerSet(this.getPublicHomesKey());
            if (this.publicHomesMarkers == null) {
                this.publicHomesMarkers = api.getMarkerAPI().createMarkerSet(this.getPublicHomesKey(), this.getPublicHomesMarkerSetName(), api.getMarkerAPI().getMarkerIcons(), false);
            } else {
                this.publicHomesMarkers.setMarkerSetLabel(this.getPublicHomesMarkerSetName());
            }
            return this.publicHomesMarkers;
        });
    }

    private Optional<MarkerIcon> getMarkerIcon(@NotNull String imageName) {
        return this.getDynmap().map(api -> {
            MarkerIcon icon = api.getMarkerAPI().getMarkerIcon(imageName);
            if (icon == null) {
                icon = api.getMarkerAPI().createMarkerIcon(imageName, imageName, this.plugin.getResource("markers/16x/" + imageName + ".png"));
            }
            return icon;
        });
    }
}

