/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.user;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.hook.LuckPermsHook;
import net.william278.huskhomes.libraries.annotations.ApiStatus;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.lang.annotations.Subst;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.User;

public abstract class OnlineUser
extends User
implements Teleportable,
CommandUser {
    protected final HuskHomes plugin;
    protected boolean markedAsInvulnerable = false;

    protected OnlineUser(@NotNull UUID uuid, @NotNull String username, @NotNull HuskHomes plugin) {
        super(uuid, username);
        this.plugin = plugin;
    }

    public abstract Position getPosition();

    public abstract Optional<Position> getBedSpawnPosition();

    public abstract double getHealth();

    @Override
    public abstract boolean hasPermission(@NotNull String var1);

    @NotNull
    public abstract Map<String, Boolean> getPermissions();

    public void sendTitle(@NotNull MineDown mineDown, boolean subTitle) {
        Component message = mineDown.toComponent();
        this.getAudience().showTitle(Title.title(subTitle ? Component.empty() : message, subTitle ? message : Component.empty()));
    }

    public void sendActionBar(@NotNull MineDown mineDown) {
        this.getAudience().sendActionBar(mineDown.toComponent());
    }

    @Override
    public void sendMessage(@NotNull MineDown mineDown) {
        this.getAudience().sendMessage(mineDown.toComponent());
    }

    public void sendMessage(@NotNull MineDown mineDown, @NotNull Locales.DisplaySlot slot) {
        switch (slot) {
            case ACTION_BAR: {
                this.sendActionBar(mineDown);
                break;
            }
            case TITLE: {
                this.sendTitle(mineDown, false);
                break;
            }
            case SUBTITLE: {
                this.sendTitle(mineDown, true);
                break;
            }
            default: {
                this.sendMessage(mineDown);
            }
        }
    }

    public void sendTranslatableMessage(@Subst(value="minecraftblock.minecraft.spawn.not_valid") @NotNull String translationKey) {
        this.getAudience().sendMessage(Component.translatable(translationKey));
    }

    public void playSound(@Subst(value="minecraft:block.note_block.banjo") @NotNull String soundEffect) throws IllegalArgumentException {
        try {
            this.getAudience().playSound(Sound.sound(Key.key(soundEffect), Sound.Source.PLAYER, 1.0f, 1.0f), Sound.Emitter.self());
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid sound effect name: " + soundEffect);
        }
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return this.plugin.getAudience(this.getUuid());
    }

    public abstract CompletableFuture<Void> dismount();

    public abstract void teleportLocally(@NotNull Location var1, boolean var2) throws TeleportationException;

    public abstract void sendPluginMessage(byte[] var1);

    public abstract boolean isMoving();

    public abstract boolean isVanished();

    @ApiStatus.Internal
    public abstract boolean hasInvulnerability();

    @ApiStatus.Internal
    public abstract void handleInvulnerability();

    @ApiStatus.Internal
    public abstract void removeInvulnerabilityIfPermitted();

    public final int getMaxHomes(int defaultMaxHomes, boolean stack) {
        List<Integer> homes = this.getNumericalPermissions("huskhomes.max_homes.");
        if (homes.isEmpty()) {
            return defaultMaxHomes;
        }
        if (stack) {
            return defaultMaxHomes + homes.stream().reduce(0, Integer::sum);
        }
        return homes.get(0);
    }

    public int getMaxPublicHomes(int defaultPublicHomes, boolean stack) {
        List<Integer> homes = this.getNumericalPermissions("huskhomes.max_public_homes.");
        if (homes.isEmpty()) {
            return defaultPublicHomes;
        }
        if (stack) {
            return defaultPublicHomes + homes.stream().reduce(0, Integer::sum);
        }
        return homes.get(0);
    }

    public int getMaxTeleportWarmup(int defaultTeleportWarmup) {
        List<Integer> homes = this.getNumericalPermissions("huskhomes.teleport_warmup.");
        if (homes.isEmpty()) {
            return defaultTeleportWarmup;
        }
        return homes.get(0);
    }

    public int getFreeHomes(int defaultFreeHomes, boolean stack) {
        List<Integer> homes = this.getNumericalPermissions("huskhomes.free_homes.");
        if (homes.isEmpty()) {
            return defaultFreeHomes;
        }
        if (stack) {
            return defaultFreeHomes + homes.stream().reduce(0, Integer::sum);
        }
        return homes.get(0);
    }

    @NotNull
    protected List<Integer> getNumericalPermissions(@NotNull String nodePrefix) {
        return this.plugin.getHook(LuckPermsHook.class).map(hook -> hook.getNumericalPermissions(this, nodePrefix)).orElseGet(() -> this.getPermissions().entrySet().stream().filter(Map.Entry::getValue).filter(perm -> ((String)perm.getKey()).startsWith(nodePrefix)).filter(perm -> OnlineUser.canParse((String)perm.getKey(), nodePrefix)).map(p -> Integer.parseInt(((String)p.getKey()).substring(nodePrefix.length()))).sorted(Collections.reverseOrder()).toList());
    }

    private static boolean canParse(@NotNull String perm, @NotNull String nodePrefix) {
        try {
            Integer.parseInt(perm.substring(nodePrefix.length()));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

