/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.random;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;

public abstract class RandomTeleportEngine {
    protected final HuskHomes plugin;
    public final String name;
    public long maxAttempts = 12L;

    protected RandomTeleportEngine(@NotNull HuskHomes plugin, @NotNull String name) {
        this.plugin = plugin;
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    protected Position getCenterPoint(@NotNull World world) {
        return this.plugin.getServerSpawn().map(spawn -> spawn.getPosition(this.plugin.getServerName())).flatMap(position -> {
            if (position.getWorld().equals(world)) {
                return Optional.of(position);
            }
            return Optional.empty();
        }).orElse(Position.at(0.0, 128.0, 0.0, world, this.plugin.getServerName()));
    }

    public abstract CompletableFuture<Optional<Position>> getRandomPosition(@NotNull World var1, @NotNull String[] var2);
}

