/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.listener;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.PaperHuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.listener.BukkitEventListener;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class PaperEventListener
extends BukkitEventListener
implements Listener {
    public PaperEventListener(@NotNull PaperHuskHomes plugin) {
        super(plugin);
        this.usePaperEvents = true;
    }

    @Override
    public void register() {
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerUpdateRespawnLocation(PlayerSetSpawnEvent event) {
        Settings.CrossServerSettings crossServer = this.getPlugin().getSettings().getCrossServer();
        if (!crossServer.isEnabled() || !crossServer.isGlobalRespawning()) {
            return;
        }
        Location location = event.getLocation();
        if (location == null) {
            return;
        }
        this.handlePlayerUpdateSpawnPoint(this.getPlugin().getOnlineUser(event.getPlayer()), BukkitHuskHomes.Adapter.adapt(location, this.getPlugin().getServerName()));
    }

    @Override
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        this.getPlugin().getOnlineUserMap().remove(event.getPlayer().getUniqueId());
        if (event.getRespawnReason() != PlayerRespawnEvent.RespawnReason.DEATH) {
            return;
        }
        super.handlePlayerRespawn(this.getPlugin().getOnlineUser(event.getPlayer()));
    }

    @Override
    @NotNull
    public PaperHuskHomes getPlugin() {
        return (PaperHuskHomes)super.getPlugin();
    }
}

