/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.database;

import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.database.H2Database;
import net.william278.huskhomes.database.MySqlDatabase;
import net.william278.huskhomes.database.PostgreSqlDatabase;
import net.william278.huskhomes.database.SqLiteDatabase;
import net.william278.huskhomes.libraries.annotations.NotNull;

public interface DatabaseProvider {
    @NotNull
    public static final String DATA_POOL_NAME = "HuskHomesHikariPool";

    @NotNull
    public Database getDatabase();

    public void setDatabase(@NotNull Database var1);

    public void closeDatabase();

    default public void loadDatabase() throws IllegalStateException {
        Database database = this.createDatabase();
        database.initialize();
        if (!database.isLoaded()) {
            throw new IllegalStateException("Failed to initialize database");
        }
        this.setDatabase(database);
    }

    @NotNull
    private Database createDatabase() {
        Database.Type type = this.getPlugin().getSettings().getDatabase().getType();
        switch (type) {
            case MYSQL: 
            case MARIADB: {
                return new MySqlDatabase(this.getPlugin());
            }
            case POSTGRESQL: {
                return new PostgreSqlDatabase(this.getPlugin());
            }
            case SQLITE: {
                return new SqLiteDatabase(this.getPlugin());
            }
            case H2: {
                return new H2Database(this.getPlugin());
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)type));
    }

    @NotNull
    public HuskHomes getPlugin();
}

