/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.PublicHomeListCommand;
import net.william278.huskhomes.command.TabCompletable;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;

public abstract class SavedPositionCommand<T extends SavedPosition>
extends Command
implements TabCompletable {
    protected final List<String> arguments;
    protected final PositionCommandType positionType;

    protected SavedPositionCommand(@NotNull List<String> aliases, @NotNull PositionCommandType positionType, @NotNull List<String> arguments, @NotNull HuskHomes plugin) {
        super(aliases, "<name>" + SavedPositionCommand.formatUsage(arguments), plugin);
        this.positionType = positionType;
        this.arguments = arguments;
        this.addAdditionalPermissions(Map.of("other", true));
        this.addAdditionalPermissions(arguments.stream().collect(HashMap::new, (m, s) -> m.put(s, false), HashMap::putAll));
    }

    @NotNull
    public String getOtherPermission() {
        if (this.positionType != PositionCommandType.WARP) {
            return super.getPermission("other");
        }
        return super.getPermission("warp");
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional<String> name = this.parseStringArg(args, 0);
        if (name.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return;
        }
        Optional<SavedPosition> position = this.positionType == PositionCommandType.WARP ? this.resolveWarp(executor, name.get()) : this.resolveHome(executor, name.get());
        position.ifPresent(p -> this.execute(executor, (SavedPosition)p, this.removeFirstArg(args)));
    }

    public abstract void execute(@NotNull CommandUser var1, @NotNull T var2, @NotNull String[] var3);

    private Optional<Home> resolveHome(@NotNull CommandUser executor, @NotNull String homeName) {
        if (homeName.contains(Home.getDelimiter())) {
            return this.resolveDelimitedHome(executor, homeName);
        }
        if (this.positionType == PositionCommandType.PUBLIC_HOME) {
            return this.resolvePublicHome(executor, homeName);
        }
        if (executor instanceof OnlineUser) {
            OnlineUser owner = (OnlineUser)executor;
            return this.resolveOwnerHome(owner, homeName);
        }
        this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
        return Optional.empty();
    }

    private Optional<Home> resolveDelimitedHome(@NotNull CommandUser executor, @NotNull String homeName) {
        String ownerUsername = homeName.substring(0, homeName.indexOf(Home.getDelimiter()));
        String ownerHome = homeName.substring(homeName.indexOf(Home.getDelimiter()) + 1);
        if (ownerUsername.isBlank() || ownerHome.isBlank()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        Optional<Home> optionalHome = this.plugin.getDatabase().getUser(ownerUsername).flatMap(owner -> this.resolveHomeByName(owner.getUser(), ownerHome));
        if (optionalHome.isEmpty()) {
            this.plugin.getLocales().getLocale(executor.hasPermission(this.getOtherPermission()) ? "error_home_invalid_other" : "error_public_home_invalid", ownerUsername, ownerHome).ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        Home home = (Home)optionalHome.get();
        if (executor instanceof OnlineUser) {
            OnlineUser user = (OnlineUser)executor;
            if (!(home.isPublic() || user.equals(home.getOwner()) || user.hasPermission(this.getOtherPermission()))) {
                this.plugin.getLocales().getLocale("error_public_home_invalid", ownerUsername, ownerHome).ifPresent(executor::sendMessage);
                return Optional.empty();
            }
        }
        return optionalHome;
    }

    private Optional<Home> resolvePublicHome(@NotNull CommandUser executor, @NotNull String homeName) {
        List<Home> publicHomes = this.plugin.getDatabase().getPublicHomes(homeName);
        if (publicHomes.isEmpty()) {
            this.plugin.getLocales().getLocale("error_unknown_public_home", homeName).ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        if (publicHomes.size() > 1) {
            this.plugin.getCommand(PublicHomeListCommand.class).ifPresent(command -> command.showPublicHomeList(executor, homeName, 1));
            return Optional.empty();
        }
        return publicHomes.stream().findFirst();
    }

    private Optional<Home> resolveOwnerHome(@NotNull OnlineUser owner, @NotNull String homeName) {
        Optional<Home> optionalHome = this.resolveHomeByName(owner, homeName);
        if (optionalHome.isEmpty()) {
            this.plugin.getLocales().getLocale("error_home_invalid", homeName).ifPresent(owner::sendMessage);
            return Optional.empty();
        }
        return optionalHome;
    }

    private Optional<Home> resolveHomeByName(@NotNull User owner, @NotNull String homeName) {
        return this.plugin.getDatabase().getHome(owner, homeName).or(() -> {
            try {
                return this.plugin.getDatabase().getHome(UUID.fromString(homeName));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
    }

    private Optional<Warp> resolveWarp(@NotNull CommandUser executor, @NotNull String warpName) {
        Optional<Warp> warp = this.resolveWarpByName(warpName);
        if (warp.isEmpty()) {
            this.plugin.getLocales().getLocale("error_warp_invalid", warpName).ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        if (executor instanceof OnlineUser) {
            OnlineUser user = (OnlineUser)executor;
            if (this.plugin.getSettings().getGeneral().isPermissionRestrictWarps() && !Warp.hasPermission(user, warpName)) {
                this.plugin.getLocales().getLocale("error_warp_invalid", warpName).ifPresent(executor::sendMessage);
                return Optional.empty();
            }
        }
        return warp;
    }

    private Optional<Warp> resolveWarpByName(@NotNull String warpName) {
        return this.plugin.getDatabase().getWarp(warpName).or(() -> {
            try {
                return this.plugin.getDatabase().getWarp(UUID.fromString(warpName));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
    }

    protected void teleport(@NotNull CommandUser executor, @NotNull Teleportable teleporter, @NotNull T position, TransactionResolver.Action ... actions) {
        if (!teleporter.equals(executor) && !executor.hasPermission(this.getPermission("other"))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        Teleport.builder(this.plugin).teleporter(teleporter).actions(actions).target((Target)position).buildAndComplete(executor.equals(teleporter), teleporter.getName());
    }

    protected boolean isInvalidOperation(String operation, CommandUser executor) {
        if (!this.arguments.contains(operation.toLowerCase())) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return true;
        }
        if (!executor.hasPermission(this.getPermission(operation.toLowerCase(Locale.ENGLISH)))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return true;
        }
        return false;
    }

    @NotNull
    private static String formatUsage(Collection<String> arguments) {
        return !arguments.isEmpty() ? " [" + String.join((CharSequence)"|", arguments) + "]" : "";
    }

    @Override
    @NotNull
    public List<String> suggest(@NotNull CommandUser executor, @NotNull String[] args) {
        return switch (this.positionType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> this.suggestHome(executor, args);
            case 2 -> this.suggestWarp(executor, args);
        };
    }

    @NotNull
    private List<String> suggestWarp(@NotNull CommandUser executor, @NotNull String[] args) {
        return switch (args.length) {
            case 0, 1 -> this.plugin.getManager().warps().getUsableWarps(executor);
            case 2 -> this.arguments.stream().filter(a -> executor.hasPermission(this.getPermission((String)a))).toList();
            default -> List.of();
        };
    }

    @NotNull
    private List<String> suggestHome(@NotNull CommandUser executor, @NotNull String[] args) {
        return switch (args.length) {
            case 0, 1 -> {
                if (args.length == 1 && args[0].contains(Home.getDelimiter()) && executor.hasPermission(this.getOtherPermission())) {
                    yield this.plugin.getManager().homes().getUserHomeIdentifiers();
                }
                if (executor instanceof OnlineUser) {
                    OnlineUser user = (OnlineUser)executor;
                    yield this.plugin.getManager().homes().getUserHomes().get(user.getName());
                }
                yield this.plugin.getManager().homes().getUserHomeIdentifiers();
            }
            case 2 -> this.arguments.stream().filter(a -> executor.hasPermission(this.getPermission((String)a))).toList();
            default -> List.of();
        };
    }

    protected static enum PositionCommandType {
        HOME,
        PUBLIC_HOME,
        WARP;

    }
}

