/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.SavedPositionCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;
import net.william278.huskhomes.util.ValidationException;

public class EditHomeCommand
extends SavedPositionCommand<Home> {
    public EditHomeCommand(@NotNull HuskHomes plugin) {
        super(List.of("edithome"), SavedPositionCommand.PositionCommandType.HOME, List.of("rename", "description", "relocate", "privacy"), plugin);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull Home home, @NotNull String[] args) {
        boolean ownerEditing = home.getOwner().equals(executor);
        if (!ownerEditing && !executor.hasPermission(this.getOtherPermission())) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        Optional<String> operation = this.parseStringArg(args, 0);
        if (operation.isEmpty()) {
            this.getHomeEditorWindow(home, !ownerEditing, ownerEditing || executor.hasPermission(this.getOtherPermission()), executor.hasPermission(this.getPermission("privacy"))).forEach(executor::sendMessage);
            return;
        }
        if (this.isInvalidOperation(operation.get(), executor)) {
            return;
        }
        switch (operation.get().toLowerCase(Locale.ENGLISH)) {
            case "rename": {
                this.setHomeName(executor, home, ownerEditing, args);
                break;
            }
            case "description": {
                this.setHomeDescription(executor, home, ownerEditing, args);
                break;
            }
            case "relocate": {
                this.setHomePosition(executor, home, ownerEditing);
                break;
            }
            case "privacy": {
                this.setHomePrivacy(executor, home, ownerEditing, args);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + operation.get().toLowerCase());
            }
        }
    }

    private void setHomeName(@NotNull CommandUser executor, @NotNull Home home, boolean ownerEditing, @NotNull String[] args) {
        Home original = home.copy();
        Optional<String> optionalName = this.parseStringArg(args, 1);
        if (optionalName.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/edithome " + home.getName() + " rename <name>").ifPresent(executor::sendMessage);
            return;
        }
        home.getMeta().setName(optionalName.get());
        this.plugin.fireEvent(this.plugin.getHomeEditEvent(home, original, executor), event -> {
            String newName = event.getHome().getName();
            try {
                this.plugin.getManager().homes().setHomeName(home, newName);
            }
            catch (ValidationException e) {
                e.dispatchHomeError(executor, false, this.plugin, newName);
                return;
            }
            if (ownerEditing) {
                this.plugin.getLocales().getLocale("edit_home_update_name", original.getName(), newName).ifPresent(executor::sendMessage);
            } else {
                this.plugin.getLocales().getLocale("edit_home_update_name_other", home.getOwner().getName(), original.getName(), newName).ifPresent(executor::sendMessage);
            }
        });
    }

    private void setHomeDescription(@NotNull CommandUser executor, @NotNull Home home, boolean ownerEditing, @NotNull String[] args) {
        Home original = home.copy();
        Optional<String> optionalDescription = this.parseGreedyArguments(args);
        if (optionalDescription.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/edithome " + home.getName() + " description <text>").ifPresent(executor::sendMessage);
            return;
        }
        home.getMeta().setDescription(optionalDescription.get());
        this.plugin.fireEvent(this.plugin.getHomeEditEvent(home, original, executor), event -> {
            String newDescription = event.getHome().getMeta().getDescription();
            try {
                this.plugin.getManager().homes().setHomeDescription(home, newDescription);
            }
            catch (ValidationException e) {
                e.dispatchHomeError(executor, false, this.plugin, newDescription);
                return;
            }
            if (ownerEditing) {
                this.plugin.getLocales().getLocale("edit_home_update_description", home.getName(), original.getMeta().getDescription(), newDescription).ifPresent(executor::sendMessage);
            } else {
                this.plugin.getLocales().getLocale("edit_home_update_description_other", home.getOwner().getName(), home.getName(), original.getMeta().getDescription(), newDescription).ifPresent(executor::sendMessage);
            }
        });
    }

    private void setHomePosition(@NotNull CommandUser executor, @NotNull Home home, boolean ownerEditing) {
        if (!(executor instanceof OnlineUser)) {
            this.plugin.getLocales().getLocale("error_in_game_only").ifPresent(executor::sendMessage);
            return;
        }
        OnlineUser user = (OnlineUser)executor;
        Home original = home.copy();
        home.update(user.getPosition());
        this.plugin.fireEvent(this.plugin.getHomeEditEvent(home, original, executor), event -> {
            try {
                this.plugin.getManager().homes().setHomePosition(home, home);
            }
            catch (ValidationException e) {
                e.dispatchHomeError(executor, false, this.plugin, home.getName());
                return;
            }
            if (ownerEditing) {
                this.plugin.getLocales().getLocale("edit_home_update_location", home.getName()).ifPresent(executor::sendMessage);
            } else {
                this.plugin.getLocales().getLocale("edit_home_update_location_other", home.getOwner().getName(), home.getName()).ifPresent(executor::sendMessage);
            }
        });
    }

    private void setHomePrivacy(@NotNull CommandUser executor, @NotNull Home home, boolean ownerEditing, @NotNull String[] args) {
        OnlineUser user;
        if (!executor.hasPermission(this.getPermission("privacy"))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        if (executor instanceof OnlineUser && !this.plugin.validateTransaction(user = (OnlineUser)executor, TransactionResolver.Action.MAKE_HOME_PUBLIC)) {
            return;
        }
        Home original = home.copy();
        home.setPublic(this.parseStringArg(args, 1).map("public"::equalsIgnoreCase).orElse(!home.isPublic()));
        this.plugin.fireEvent(this.plugin.getHomeEditEvent(home, original, executor), event -> {
            String privacy;
            try {
                this.plugin.getManager().homes().setHomePrivacy(home.getOwner().equals(executor) ? (OnlineUser)executor : home.getOwner(), home, home.isPublic());
            }
            catch (ValidationException e) {
                OnlineUser user;
                int maxHomes = this.plugin.getManager().homes().getMaxPublicHomes(executor instanceof OnlineUser ? (user = (OnlineUser)executor) : null);
                e.dispatchHomeError(executor, false, this.plugin, Integer.toString(maxHomes));
                return;
            }
            if (executor instanceof OnlineUser) {
                OnlineUser user = (OnlineUser)executor;
                this.plugin.performTransaction(user, TransactionResolver.Action.MAKE_HOME_PUBLIC);
            }
            String string = privacy = home.isPublic() ? "public" : "private";
            if (ownerEditing) {
                this.plugin.getLocales().getLocale("edit_home_privacy_" + privacy + "_success", home.getName()).ifPresent(executor::sendMessage);
            } else {
                this.plugin.getLocales().getLocale("edit_home_privacy_" + privacy + "_success_other", home.getOwner().getName(), home.getName()).ifPresent(executor::sendMessage);
            }
        });
    }

    @NotNull
    private List<MineDown> getHomeEditorWindow(@NotNull Home home, boolean otherViewer, boolean showTeleportButton, boolean showPrivacyToggleButton) {
        ArrayList<MineDown> messages = new ArrayList<MineDown>();
        if (!otherViewer) {
            this.plugin.getLocales().getLocale("edit_home_menu_title", home.getName()).ifPresent(messages::add);
        } else {
            this.plugin.getLocales().getLocale("edit_home_menu_title_other", home.getOwner().getName(), home.getName()).ifPresent(messages::add);
        }
        this.plugin.getLocales().getLocale("edit_home_menu_metadata_" + (!home.isPublic() ? "private" : "public"), home.getMeta().getCreationTimestamp().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT)), home.getUuid().toString().split(Pattern.quote("-"))[0], home.getUuid().toString()).ifPresent(messages::add);
        if (!home.getMeta().getDescription().isEmpty()) {
            this.plugin.getLocales().getLocale("edit_home_menu_description", this.plugin.getLocales().truncateText(home.getMeta().getDescription(), 50), home.getMeta().getDescription()).ifPresent(messages::add);
        }
        if (!this.plugin.getSettings().getCrossServer().isEnabled()) {
            this.plugin.getLocales().getLocale("edit_home_menu_world", home.getWorld().getName()).ifPresent(messages::add);
        } else {
            this.plugin.getLocales().getLocale("edit_home_menu_world_server", home.getWorld().getName(), home.getServer()).ifPresent(messages::add);
        }
        this.plugin.getLocales().getLocale("edit_home_menu_coordinates", String.format("%.1f", home.getX()), String.format("%.1f", home.getY()), String.format("%.1f", home.getZ()), String.format("%.2f", Float.valueOf(home.getYaw())), String.format("%.2f", Float.valueOf(home.getPitch()))).ifPresent(messages::add);
        if (showTeleportButton) {
            this.plugin.getLocales().getLocale("edit_home_menu_use_buttons", home.getSafeIdentifier()).ifPresent(messages::add);
        }
        this.plugin.getLocales().getRawLocale("edit_home_menu_manage_buttons", home.getSafeIdentifier(), showPrivacyToggleButton ? this.plugin.getLocales().getRawLocale("edit_home_menu_privacy_button_" + (home.isPublic() ? "private" : "public"), home.getSafeIdentifier()).orElse("") : "").map(MineDown::new).ifPresent(messages::add);
        this.plugin.getLocales().getLocale("edit_home_menu_meta_edit_buttons", home.getSafeIdentifier()).ifPresent(messages::add);
        return messages;
    }
}

