/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.BackCommand;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.DelHomeCommand;
import net.william278.huskhomes.command.DelWarpCommand;
import net.william278.huskhomes.command.EditHomeCommand;
import net.william278.huskhomes.command.EditWarpCommand;
import net.william278.huskhomes.command.HomeListCommand;
import net.william278.huskhomes.command.HuskHomesCommand;
import net.william278.huskhomes.command.Node;
import net.william278.huskhomes.command.PrivateHomeCommand;
import net.william278.huskhomes.command.PublicHomeCommand;
import net.william278.huskhomes.command.PublicHomeListCommand;
import net.william278.huskhomes.command.RtpCommand;
import net.william278.huskhomes.command.SetHomeCommand;
import net.william278.huskhomes.command.SetSpawnCommand;
import net.william278.huskhomes.command.SetWarpCommand;
import net.william278.huskhomes.command.SpawnCommand;
import net.william278.huskhomes.command.TpAllCommand;
import net.william278.huskhomes.command.TpCommand;
import net.william278.huskhomes.command.TpHereCommand;
import net.william278.huskhomes.command.TpIgnoreCommand;
import net.william278.huskhomes.command.TpOfflineCommand;
import net.william278.huskhomes.command.TpRequestCommand;
import net.william278.huskhomes.command.TpRespondCommand;
import net.william278.huskhomes.command.TpaAllCommand;
import net.william278.huskhomes.command.WarpCommand;
import net.william278.huskhomes.command.WarpListCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.teleport.TeleportRequest;
import net.william278.huskhomes.user.CommandUser;

public interface CommandProvider {
    @NotNull
    public List<Command> getCommands();

    default public <T extends Command> Optional<T> getCommand(@NotNull Class<T> commandClass) {
        return this.getCommands().stream().filter(commandClass::isInstance).map(commandClass::cast).findFirst();
    }

    default public <T extends Command> boolean canUseCommand(@NotNull Class<T> commandClass, @NotNull CommandUser user, String ... nodes) {
        return this.getCommand(commandClass).map(command -> command.hasPermission(user, nodes)).orElse(false);
    }

    public void registerCommands(@NotNull List<Command> var1);

    default public void loadCommands() {
        ArrayList commands = Lists.newArrayList();
        commands.add(new PrivateHomeCommand(this.getPlugin()));
        commands.add(new SetHomeCommand(this.getPlugin()));
        commands.add(new HomeListCommand(this.getPlugin()));
        commands.add(new DelHomeCommand(this.getPlugin()));
        commands.add(new EditHomeCommand(this.getPlugin()));
        commands.add(new PublicHomeCommand(this.getPlugin()));
        commands.add(new PublicHomeListCommand(this.getPlugin()));
        commands.add(new WarpCommand(this.getPlugin()));
        commands.add(new SetWarpCommand(this.getPlugin()));
        commands.add(new WarpListCommand(this.getPlugin()));
        commands.add(new DelWarpCommand(this.getPlugin()));
        commands.add(new EditWarpCommand(this.getPlugin()));
        commands.add(new TpCommand(this.getPlugin()));
        commands.add(new TpHereCommand(this.getPlugin()));
        commands.add(new TpRequestCommand(this.getPlugin(), TeleportRequest.Type.TPA));
        commands.add(new TpRequestCommand(this.getPlugin(), TeleportRequest.Type.TPA_HERE));
        commands.add(new TpRespondCommand(this.getPlugin(), true));
        commands.add(new TpRespondCommand(this.getPlugin(), false));
        commands.add(new TpaAllCommand(this.getPlugin()));
        commands.add(new RtpCommand(this.getPlugin()));
        commands.add(new TpIgnoreCommand(this.getPlugin()));
        commands.add(new TpOfflineCommand(this.getPlugin()));
        commands.add(new TpAllCommand(this.getPlugin()));
        commands.add(new SpawnCommand(this.getPlugin()));
        commands.add(new SetSpawnCommand(this.getPlugin()));
        commands.add(new BackCommand(this.getPlugin()));
        commands.add(new HuskHomesCommand(this.getPlugin()));
        this.registerCommands(commands.stream().filter(command -> !this.getPlugin().getSettings().isCommandDisabled((Command)command)).sorted(Comparator.comparing(Node::getName)).toList());
    }

    @NotNull
    public HuskHomes getPlugin();
}

