/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.desertwell.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.desertwell.util.Version;
import net.william278.huskhomes.libraries.json.JSONArray;
import net.william278.huskhomes.libraries.json.JSONObject;

public class UpdateChecker {
    private final Endpoint endpoint;
    private final Version currentVersion;
    private final String versionMetaDelimiter;
    private final String resource;

    private UpdateChecker(@NotNull Endpoint endpoint, @NotNull Version currentVersion, @NotNull String versionMetaDelimiter, @NotNull String resource) {
        this.endpoint = endpoint;
        this.currentVersion = currentVersion;
        this.versionMetaDelimiter = versionMetaDelimiter;
        this.resource = resource;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public CompletableFuture<Completed> check() {
        return CompletableFuture.supplyAsync(() -> new Completed(this, Version.fromString(this.endpoint.query(this.resource), this.versionMetaDelimiter))).exceptionally(throwable -> new Completed(this, this.currentVersion));
    }

    public static class Completed {
        private final UpdateChecker checker;
        private final Version latestVersion;

        private Completed(@NotNull UpdateChecker checker, @NotNull Version latestVersion) {
            this.checker = checker;
            this.latestVersion = latestVersion;
        }

        @NotNull
        public Version getLatestVersion() {
            return this.latestVersion;
        }

        @NotNull
        public Version getCurrentVersion() {
            return this.checker.currentVersion;
        }

        public boolean isUpToDate() {
            return this.checker.currentVersion.compareTo(this.latestVersion) >= 0;
        }
    }

    public static enum Endpoint {
        SPIGOT(resource -> {
            String string;
            String url = Endpoint.formatId("https://api.spigotmc.org/legacy/update.php?resource={id}", resource);
            InputStreamReader reader = new InputStreamReader(new URL(url).openConnection().getInputStream());
            try {
                string = new BufferedReader(reader).readLine();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to fetch latest version", e);
                }
            }
            reader.close();
            return string;
        }),
        POLYMART(resource -> {
            String string;
            String url = Endpoint.formatId("https://api.polymart.org/v1/getResourceInfoSimple/?resource_id={id}&key=version", resource);
            InputStreamReader reader = new InputStreamReader(new URL(url).openConnection().getInputStream());
            try {
                string = new BufferedReader(reader).readLine();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to fetch latest version", e);
                }
            }
            reader.close();
            return string;
        }),
        MODRINTH(resource -> {
            String url = Endpoint.formatId("https://api.modrinth.com/v2/project/{id}/version", resource);
            try (InputStreamReader reader = new InputStreamReader(new URL(url).openConnection().getInputStream());){
                JSONArray array = new JSONArray(new BufferedReader(reader).readLine());
                int i = 0;
                while (i < array.length()) {
                    JSONObject object = array.getJSONObject(i);
                    if (object.getString("version_type").equals("release")) {
                        String string = object.getString("version_number");
                        return string;
                    }
                    ++i;
                }
                throw new IllegalStateException("No versions found");
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to fetch latest version", e);
            }
        }),
        GITHUB(resource -> {
            String string;
            String url = Endpoint.formatId("https://api.github.com/repos/{id}/releases/latest", resource);
            InputStreamReader reader = new InputStreamReader(new URL(url).openConnection().getInputStream());
            try {
                string = new JSONObject(new BufferedReader(reader).readLine()).getString("tag_name");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to fetch latest version", e);
                }
            }
            reader.close();
            return string;
        });

        private final Function<String, String> queryFunction;

        private Endpoint(Function<String, String> queryFunction) {
            this.queryFunction = queryFunction;
        }

        @NotNull
        public String query(@NotNull String resource) {
            return this.queryFunction.apply(resource);
        }

        @NotNull
        private static String formatId(@NotNull String endpoint, @NotNull String resource) {
            return endpoint.replaceAll(Pattern.quote("{id}"), resource);
        }
    }

    public static class Builder {
        private Endpoint endpoint = Endpoint.SPIGOT;
        private Version currentVersion;
        private String versionMetaDelimiter = "-";
        private String resource;

        private Builder() {
        }

        @NotNull
        public Builder endpoint(@NotNull Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @NotNull
        public Builder currentVersion(@NotNull Version currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        @NotNull
        public Builder versionMetaDelimiter(@NotNull String versionMetaDelimiter) {
            this.versionMetaDelimiter = versionMetaDelimiter;
            return this;
        }

        @NotNull
        public Builder resource(@NotNull String resource) {
            this.resource = resource;
            return this;
        }

        @NotNull
        public UpdateChecker build() {
            if (this.currentVersion == null) {
                throw new IllegalStateException("Current version is not set");
            }
            if (this.resource == null) {
                throw new IllegalStateException("Resource is not set");
            }
            return new UpdateChecker(this.endpoint, this.currentVersion, this.versionMetaDelimiter, this.resource);
        }
    }
}

