/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.configlib;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.william278.huskhomes.libraries.configlib.ConfigurationException;
import net.william278.huskhomes.libraries.configlib.FieldExtractor;
import net.william278.huskhomes.libraries.configlib.FieldFilters;
import net.william278.huskhomes.libraries.configlib.Reflect;
import net.william278.huskhomes.libraries.configlib.Validator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum FieldExtractors implements FieldExtractor
{
    CONFIGURATION{

        @Override
        public Stream<Field> extract(Class<?> cls) {
            Validator.requireNonNull(cls, "configuration class");
            Validator.requireConfigurationClass(cls);
            List<Class<?>> classes = FieldExtractors.extractClassesWhile(cls, Reflect::isConfigurationClass);
            List<Field> fields = classes.stream().flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(FieldFilters.DEFAULT).toList();
            FieldExtractors.requireNoShadowing(fields);
            return fields.stream();
        }
    };


    private static void requireNoShadowing(List<Field> fields) {
        LinkedHashMap map = new LinkedHashMap();
        for (Field field : fields) {
            String fieldName = field.getName();
            Class<?> fieldClass = field.getDeclaringClass();
            if (map.containsKey(fieldName)) {
                Class superClass = (Class)map.get(fieldName);
                String msg = "Shadowing of fields is not supported. Field '" + fieldName + "' of class " + fieldClass.getSimpleName() + " shadows field '" + fieldName + "' of class " + superClass.getSimpleName() + ".";
                throw new ConfigurationException(msg);
            }
            map.put(fieldName, fieldClass);
        }
    }

    private static List<Class<?>> extractClassesWhile(Class<?> cls, Predicate<Class<?>> condition) {
        ArrayList classes = new ArrayList();
        Class<?> current = cls;
        while (condition.test(current)) {
            classes.add(current);
            current = current.getSuperclass();
        }
        Collections.reverse(classes);
        return classes;
    }
}

