/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.MapHook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.desertwell.util.ThrowingConsumer;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.user.User;

@PluginHook(name="BlueMap", register=PluginHook.Register.ON_ENABLE)
public class BlueMapHook
extends MapHook {
    private Map<String, MarkerSet> publicHomesMarkerSets;
    private Map<String, MarkerSet> warpsMarkerSets;

    public BlueMapHook(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void load() {
        BlueMapAPI.onEnable(api -> {
            this.publicHomesMarkerSets = new ConcurrentHashMap<String, MarkerSet>();
            this.warpsMarkerSets = new ConcurrentHashMap<String, MarkerSet>();
            for (World world : this.plugin.getWorlds()) {
                this.editMapWorld(world, mapWorld -> {
                    MarkerSet homeMarkers = MarkerSet.builder().label(this.getPublicHomesMarkerSetName()).build();
                    MarkerSet warpsMarkers = MarkerSet.builder().label(this.getWarpsMarkerSetName()).build();
                    for (BlueMapMap map : mapWorld.getMaps()) {
                        map.getMarkerSets().put(this.getPublicHomesKey(), homeMarkers);
                        map.getMarkerSets().put(this.getWarpsKey(), warpsMarkers);
                    }
                    this.publicHomesMarkerSets.put(world.getName(), homeMarkers);
                    this.warpsMarkerSets.put(world.getName(), warpsMarkers);
                });
            }
            this.populateMap();
        });
    }

    @Override
    public void addHome(@NotNull Home home) {
        if (!this.isValidPosition(home)) {
            return;
        }
        this.editPublicHomesMarkerSet(home.getWorld(), markerSet -> {
            String markerId = String.valueOf(home.getOwner().getUuid()) + ":" + String.valueOf(home.getUuid());
            markerSet.remove(markerId);
            markerSet.put(markerId, (Marker)((POIMarker.Builder)((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label("/phome " + home.getIdentifier())).position(home.getX(), home.getY(), home.getZ())).maxDistance(5000.0)).icon(this.getIcon("public-home"), 25, 25).build());
        });
    }

    @Override
    public void removeHome(@NotNull Home home) {
        this.editPublicHomesMarkerSet(home.getWorld(), markerSet -> markerSet.remove(String.valueOf(home.getOwner().getUuid()) + ":" + String.valueOf(home.getUuid())));
    }

    @Override
    public void clearHomes(@NotNull User user) {
        if (this.publicHomesMarkerSets != null) {
            this.publicHomesMarkerSets.values().forEach(markerSet -> markerSet.getMarkers().keySet().removeIf(markerId -> markerId.startsWith(user.getUuid().toString())));
        }
    }

    @Override
    public void clearHomes(@NotNull String worldName) {
        if (this.publicHomesMarkerSets != null) {
            this.publicHomesMarkerSets.get(worldName).getMarkers().clear();
        }
    }

    @Override
    public void addWarp(@NotNull Warp warp) {
        if (!this.isValidPosition(warp)) {
            return;
        }
        this.editWarpsMarkerSet(warp.getWorld(), markerSet -> {
            String markerId = warp.getUuid().toString();
            markerSet.remove(markerId);
            markerSet.put(markerId, (Marker)((POIMarker.Builder)((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label("/warp " + warp.getName())).position(warp.getX(), warp.getY(), warp.getZ())).maxDistance(5000.0)).icon(this.getIcon("warp"), 25, 25).build());
        });
    }

    @Override
    public void removeWarp(@NotNull Warp warp) {
        this.editWarpsMarkerSet(warp.getWorld(), markerSet -> markerSet.remove(warp.getUuid().toString()));
    }

    @Override
    public void clearWarps() {
        if (this.warpsMarkerSets != null) {
            this.warpsMarkerSets.values().forEach(markerSet -> markerSet.getMarkers().clear());
        }
    }

    @Override
    public void clearWarps(@NotNull String worldName) {
        if (this.warpsMarkerSets != null) {
            this.warpsMarkerSets.get(worldName).getMarkers().clear();
        }
    }

    @Nullable
    private String getIcon(@NotNull String iconName) {
        return BlueMapAPI.getInstance().map(api -> {
            String iconFileName;
            File iconFile;
            Path icons = api.getWebApp().getWebRoot().resolve("icons").resolve("huskhomes");
            if (!icons.toFile().exists() && !icons.toFile().mkdirs()) {
                this.plugin.log(Level.WARNING, "Failed to create BlueMap icons directory", new Throwable[0]);
            }
            if (!(iconFile = icons.resolve(iconFileName = iconName + ".png").toFile()).exists()) {
                try (InputStream readIcon = this.plugin.getResource("markers/50x/" + iconFileName);){
                    if (readIcon == null) {
                        throw new FileNotFoundException("Could not find icon resource: " + iconFileName);
                    }
                    Files.copy(readIcon, iconFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    this.plugin.log(Level.WARNING, "Failed to load icon for BlueMap hook", e);
                }
            }
            return "icons/huskhomes/" + iconFileName;
        }).orElse(null);
    }

    private void editPublicHomesMarkerSet(@NotNull World world, @NotNull ThrowingConsumer<MarkerSet> editor) {
        this.editMapWorld(world, mapWorld -> {
            if (this.publicHomesMarkerSets != null) {
                editor.accept(this.publicHomesMarkerSets.get(world.getName()));
            }
        });
    }

    private void editWarpsMarkerSet(@NotNull World world, @NotNull ThrowingConsumer<MarkerSet> editor) {
        this.editMapWorld(world, mapWorld -> {
            if (this.warpsMarkerSets != null) {
                editor.accept(this.warpsMarkerSets.get(world.getName()));
            }
        });
    }

    private void editMapWorld(@NotNull World world, @NotNull ThrowingConsumer<BlueMapWorld> editor) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)world.getName())).ifPresent(editor);
    }
}

