/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.HomeCommand;
import net.william278.huskhomes.command.HomeListCommand;
import net.william278.huskhomes.command.SavedPositionCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;

public class PrivateHomeCommand
extends HomeCommand {
    protected PrivateHomeCommand(@NotNull HuskHomes plugin) {
        super(List.of("home"), SavedPositionCommand.PositionCommandType.HOME, plugin);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        if (args.length == 0) {
            if (!(executor instanceof OnlineUser)) {
                this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
                return;
            }
            OnlineUser user = (OnlineUser)executor;
            List<Home> homes = this.plugin.getDatabase().getHomes(user);
            if (homes.size() == 1) {
                super.execute(executor, homes.get(0), args);
                return;
            }
            this.plugin.getCommand(HomeListCommand.class).ifPresent(command -> command.showHomeList(executor, user.getName(), 1));
            return;
        }
        super.execute(executor, args);
    }
}

