/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.SavedPositionCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.util.ValidationException;

public class DelWarpCommand
extends SavedPositionCommand<Warp> {
    public DelWarpCommand(@NotNull HuskHomes plugin) {
        super(List.of("delwarp"), SavedPositionCommand.PositionCommandType.WARP, List.of(), plugin);
        this.setOperatorCommand(true);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        if (this.handleDeleteAll(executor, args)) {
            return;
        }
        super.execute(executor, args);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull Warp warp, @NotNull String[] args) {
        if (this.plugin.getSettings().getGeneral().isPermissionRestrictWarps() && !warp.hasPermission(executor)) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.fireEvent(this.plugin.getWarpDeleteEvent(warp, executor), event -> {
            try {
                this.plugin.getManager().warps().deleteWarp(warp);
            }
            catch (ValidationException e) {
                e.dispatchWarpError(executor, this.plugin, warp.getName());
                return;
            }
            this.plugin.getLocales().getLocale("warp_deleted", warp.getName()).ifPresent(executor::sendMessage);
        });
    }

    private boolean handleDeleteAll(@NotNull CommandUser executor, @NotNull String[] args) {
        if (args.length >= 1 && args[0].equalsIgnoreCase("all")) {
            if (!this.parseStringArg(args, 1).map(confirm -> confirm.equalsIgnoreCase("confirm")).orElse(false).booleanValue()) {
                this.plugin.getLocales().getLocale("delete_all_warps_confirm").ifPresent(executor::sendMessage);
                return true;
            }
            this.plugin.fireEvent(this.plugin.getDeleteAllWarpsEvent(executor), event -> {
                int deleted = this.plugin.getManager().warps().deleteAllWarps();
                if (deleted == 0) {
                    this.plugin.getLocales().getLocale("error_no_warps_set").ifPresent(executor::sendMessage);
                    return;
                }
                this.plugin.getLocales().getLocale("delete_all_warps_success", Integer.toString(deleted)).ifPresent(executor::sendMessage);
            });
            return true;
        }
        return false;
    }
}

