/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.AudienceProvider;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.api.HuskHomesAPI;
import net.william278.huskhomes.command.BukkitCommand;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.config.Server;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.config.Spawn;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.event.BukkitEventDispatcher;
import net.william278.huskhomes.hook.BukkitHookProvider;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.annotations.TestOnly;
import net.william278.huskhomes.libraries.bstats.bukkit.Metrics;
import net.william278.huskhomes.libraries.bstats.charts.SimplePie;
import net.william278.huskhomes.libraries.desertwell.util.Version;
import net.william278.huskhomes.libraries.paperlib.MorePaperLib;
import net.william278.huskhomes.libraries.paperlib.scheduling.AsynchronousScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.AttachedScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.GracefulScheduling;
import net.william278.huskhomes.libraries.paperlib.scheduling.RegionalScheduler;
import net.william278.huskhomes.libraries.toilet.BukkitToilet;
import net.william278.huskhomes.libraries.toilet.Toilet;
import net.william278.huskhomes.listener.BukkitEventListener;
import net.william278.huskhomes.listener.EventListener;
import net.william278.huskhomes.manager.Manager;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.PluginMessageBroker;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.random.RandomTeleportEngine;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.user.BukkitUserProvider;
import net.william278.huskhomes.user.ConsoleUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.BukkitSavePositionProvider;
import net.william278.huskhomes.util.BukkitTask;
import net.william278.huskhomes.util.UnsafeBlocks;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BukkitHuskHomes
extends JavaPlugin
implements HuskHomes,
BukkitTask.Supplier,
BukkitEventDispatcher,
PluginMessageListener,
BukkitHookProvider,
BukkitSavePositionProvider,
BukkitUserProvider {
    private AudienceProvider audiences;
    private AsynchronousScheduler asyncScheduler;
    private RegionalScheduler regionalScheduler;
    private MorePaperLib morePaperLib;
    private Toilet toilet;
    private final Set<SavedUser> savedUsers = Sets.newHashSet();
    private final Set<UUID> currentlyOnWarmup = Sets.newConcurrentHashSet();
    private final Map<UUID, OnlineUser> onlineUserMap = Maps.newHashMap();
    private final Map<String, List<User>> globalUserList = Maps.newConcurrentMap();
    private final List<Command> commands = Lists.newArrayList();
    private Set<Hook> hooks = Sets.newHashSet();
    private Settings settings;
    private Locales locales;
    private Database database;
    private Manager manager;
    private EventListener eventListener;
    private RandomTeleportEngine randomTeleportEngine;
    private Spawn serverSpawn;
    private UnsafeBlocks unsafeBlocks;
    @Nullable
    private Broker broker;
    @Nullable
    private Server serverName;

    @TestOnly
    protected BukkitHuskHomes(@NotNull JavaPluginLoader loader, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file) {
        super(loader, description, dataFolder, file);
    }

    public void onLoad() {
        this.load();
    }

    public void onEnable() {
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.morePaperLib = new MorePaperLib((Plugin)this);
        this.toilet = BukkitToilet.create(this.getDumpOptions());
        this.enable();
        this.loadCommands();
    }

    public void onDisable() {
        this.shutdown();
        if (this.audiences != null) {
            this.audiences.close();
        }
    }

    @Override
    public void loadAPI() {
        HuskHomesAPI.register(this);
    }

    @Override
    public void loadMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this, 8430);
            metrics.addCustomChart(new SimplePie("bungee_mode", () -> Boolean.toString(this.getSettings().getCrossServer().isEnabled())));
            metrics.addCustomChart(new SimplePie("language", () -> this.getSettings().getLanguage().toLowerCase()));
            metrics.addCustomChart(new SimplePie("database_type", () -> this.getSettings().getDatabase().getType().getDisplayName()));
            metrics.addCustomChart(new SimplePie("using_economy", () -> Boolean.toString(this.isUsingEconomy())));
            metrics.addCustomChart(new SimplePie("using_map", () -> Boolean.toString(this.getSettings().getMapHook().isEnabled())));
            this.getBroker().ifPresent(broker -> metrics.addCustomChart(new SimplePie("messenger_type", () -> this.settings.getCrossServer().getBrokerType().getDisplayName())));
        }
        catch (Throwable e) {
            this.log(Level.WARNING, "Failed to register plugin metrics", e);
        }
    }

    @Override
    @NotNull
    public BukkitEventListener createListener() {
        return new BukkitEventListener(this);
    }

    @Override
    public void disablePlugin() {
        this.log(Level.INFO, "Disabling HuskHomes...", new Throwable[0]);
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    @Override
    @NotNull
    public Version getPluginVersion() {
        return Version.fromString(this.getDescription().getVersion());
    }

    @Override
    @NotNull
    public String getServerType() {
        return String.format("%s/%s", this.getServer().getName(), this.getServer().getVersion());
    }

    @Override
    @NotNull
    public Version getMinecraftVersion() {
        return Version.fromString(this.getServer().getBukkitVersion());
    }

    @Override
    public Optional<Broker> getBroker() {
        return Optional.ofNullable(this.broker);
    }

    @Override
    public void closeBroker() {
        if (this.broker != null) {
            this.broker.close();
        }
    }

    @Override
    @NotNull
    public ConsoleUser getConsole() {
        return new ConsoleUser(this.audiences.console());
    }

    @Override
    @NotNull
    public Audience getAudience(@NotNull UUID user) {
        return this.audiences.player(user);
    }

    @Override
    public void setWorldSpawn(@NotNull Position position) {
        Objects.requireNonNull(Adapter.adapt(position).getWorld()).setSpawnLocation(Adapter.adapt(position));
    }

    @Override
    public void registerCommands(@NotNull List<Command> commands) {
        commands.stream().peek(this.commands::add).map(c -> new BukkitCommand((Command)c, this.getPlugin())).forEach(BukkitCommand::register);
    }

    @Override
    public Optional<Spawn> getServerSpawn() {
        return Optional.ofNullable(this.serverSpawn);
    }

    @Override
    @NotNull
    public String getServerName() {
        return this.serverName != null ? this.serverName.getName() : "server";
    }

    @Override
    @NotNull
    public Path getConfigDirectory() {
        return this.getDataFolder().toPath();
    }

    @Override
    @NotNull
    public List<World> getWorlds() {
        return this.getServer().getWorlds().stream().map(Adapter::adapt).toList();
    }

    @Override
    public void setupPluginMessagingChannels() {
        String channelId = "BungeeCord";
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.getLogger().log(level, message, exceptions[0]);
            return;
        }
        this.getLogger().log(level, message);
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] message) {
        Broker broker;
        if (this.broker != null && (broker = this.broker) instanceof PluginMessageBroker) {
            PluginMessageBroker pluginMessenger = (PluginMessageBroker)broker;
            if (this.getSettings().getCrossServer().getBrokerType() == Broker.Type.PLUGIN_MESSAGE) {
                pluginMessenger.onReceive(channel, this.getOnlineUser(player), message);
            }
        }
    }

    @NotNull
    public GracefulScheduling getScheduler() {
        return this.morePaperLib.scheduling();
    }

    @NotNull
    public AsynchronousScheduler getAsyncScheduler() {
        return this.asyncScheduler == null ? (this.asyncScheduler = this.getScheduler().asyncScheduler()) : this.asyncScheduler;
    }

    @NotNull
    public RegionalScheduler getSyncScheduler() {
        return this.regionalScheduler == null ? (this.regionalScheduler = this.getScheduler().globalRegionalScheduler()) : this.regionalScheduler;
    }

    @NotNull
    public AttachedScheduler getUserSyncScheduler(@NotNull OnlineUser user) {
        return this.getScheduler().entitySpecificScheduler((Entity)((BukkitUser)user).getPlayer());
    }

    @Override
    public void closeDatabase() {
        if (this.database != null) {
            this.database.close();
        }
    }

    @Override
    @NotNull
    public BukkitHuskHomes getPlugin() {
        return this;
    }

    @Override
    @Generated
    public AudienceProvider getAudiences() {
        return this.audiences;
    }

    @Generated
    public RegionalScheduler getRegionalScheduler() {
        return this.regionalScheduler;
    }

    @Generated
    public MorePaperLib getMorePaperLib() {
        return this.morePaperLib;
    }

    @Override
    @Generated
    public Toilet getToilet() {
        return this.toilet;
    }

    @Override
    @Generated
    public Set<SavedUser> getSavedUsers() {
        return this.savedUsers;
    }

    @Override
    @Generated
    public Set<UUID> getCurrentlyOnWarmup() {
        return this.currentlyOnWarmup;
    }

    @Override
    @Generated
    public Map<UUID, OnlineUser> getOnlineUserMap() {
        return this.onlineUserMap;
    }

    @Override
    @Generated
    public Map<String, List<User>> getGlobalUserList() {
        return this.globalUserList;
    }

    @Override
    @Generated
    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    @Generated
    public Set<Hook> getHooks() {
        return this.hooks;
    }

    @Override
    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public Locales getLocales() {
        return this.locales;
    }

    @Override
    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public Manager getManager() {
        return this.manager;
    }

    @Generated
    public EventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    @Generated
    public RandomTeleportEngine getRandomTeleportEngine() {
        return this.randomTeleportEngine;
    }

    @Override
    @Generated
    public UnsafeBlocks getUnsafeBlocks() {
        return this.unsafeBlocks;
    }

    @Generated
    public BukkitHuskHomes() {
    }

    @Override
    @Generated
    public void setHooks(Set<Hook> hooks) {
        this.hooks = hooks;
    }

    @Override
    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    @Generated
    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    @Override
    @Generated
    public void setDatabase(Database database) {
        this.database = database;
    }

    @Override
    @Generated
    public void setManager(Manager manager) {
        this.manager = manager;
    }

    @Generated
    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    @Generated
    public void setRandomTeleportEngine(RandomTeleportEngine randomTeleportEngine) {
        this.randomTeleportEngine = randomTeleportEngine;
    }

    @Override
    @Generated
    public void setServerSpawn(Spawn serverSpawn) {
        this.serverSpawn = serverSpawn;
    }

    @Override
    @Generated
    public void setUnsafeBlocks(UnsafeBlocks unsafeBlocks) {
        this.unsafeBlocks = unsafeBlocks;
    }

    @Override
    @Generated
    public void setBroker(@Nullable Broker broker) {
        this.broker = broker;
    }

    @Override
    @Generated
    public void setServerName(@Nullable Server serverName) {
        this.serverName = serverName;
    }

    public static class Adapter {
        @NotNull
        public static Location adapt(@NotNull org.bukkit.Location location) {
            return Position.at(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), Adapter.adapt(Objects.requireNonNull(location.getWorld(), "Location world is null")));
        }

        @NotNull
        public static Position adapt(@NotNull org.bukkit.Location location, @NotNull String server) {
            return Position.at(Adapter.adapt(location), server);
        }

        @NotNull
        public static org.bukkit.Location adapt(@NotNull Location position) {
            return new org.bukkit.Location(Adapter.adapt(position.getWorld()), position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
        }

        @Nullable
        public static org.bukkit.World adapt(@NotNull World world) {
            return Optional.ofNullable(Bukkit.getWorld((UUID)world.getUuid())).or(() -> Optional.ofNullable(Bukkit.getWorld((String)world.getName()))).orElse(null);
        }

        @NotNull
        public static World adapt(@NotNull org.bukkit.World world) {
            return World.from(world.getName(), world.getUID(), World.Environment.match(world.getEnvironment().name()));
        }
    }
}

