/*
 * Decompiled with CFR 0.152.
 */
package com.fatboyindustrial.gsonjavatime;

import java.lang.reflect.Type;
import java.time.ZoneId;
import net.william278.huskhomes.libraries.gson.JsonDeserializationContext;
import net.william278.huskhomes.libraries.gson.JsonDeserializer;
import net.william278.huskhomes.libraries.gson.JsonElement;
import net.william278.huskhomes.libraries.gson.JsonParseException;
import net.william278.huskhomes.libraries.gson.JsonPrimitive;
import net.william278.huskhomes.libraries.gson.JsonSerializationContext;
import net.william278.huskhomes.libraries.gson.JsonSerializer;

public class ZoneIdConverter
implements JsonSerializer<ZoneId>,
JsonDeserializer<ZoneId> {
    @Override
    public JsonElement serialize(ZoneId src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return null;
        }
        return new JsonPrimitive(src.getId());
    }

    @Override
    public ZoneId deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json == null) {
            return null;
        }
        if (json.isJsonNull()) {
            return null;
        }
        String zoneIdentifier = json.getAsString();
        if (zoneIdentifier == null || zoneIdentifier.isEmpty()) {
            return null;
        }
        return ZoneId.of(zoneIdentifier);
    }
}

