/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.user.OnlineUser;

public class PluginMessageBroker
extends Broker {
    public static final String BUNGEE_CHANNEL_ID = "BungeeCord";

    protected PluginMessageBroker(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void initialize() throws RuntimeException {
        this.plugin.setupPluginMessagingChannels();
    }

    public final void onReceive(@NotNull String channel, @NotNull OnlineUser user, byte[] message) {
        if (!channel.equals(BUNGEE_CHANNEL_ID)) {
            return;
        }
        ByteArrayDataInput inputStream = ByteStreams.newDataInput((byte[])message);
        String subChannelId = inputStream.readUTF();
        if (!subChannelId.equals(this.getSubChannelId())) {
            return;
        }
        short messageLength = inputStream.readShort();
        byte[] messageBody = new byte[messageLength];
        inputStream.readFully(messageBody);
        try (DataInputStream messageReader = new DataInputStream(new ByteArrayInputStream(messageBody));){
            super.handle(user, this.plugin.getMessageFromJson(messageReader.readUTF()));
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "Failed to fully read plugin message", e);
        }
    }

    @Override
    protected void send(@NotNull Message message, @NotNull OnlineUser sender) {
        ByteArrayDataOutput messageWriter = ByteStreams.newDataOutput();
        messageWriter.writeUTF(message.getTargetType().getPluginMessageChannel());
        messageWriter.writeUTF(message.getTarget());
        messageWriter.writeUTF(this.getSubChannelId());
        try (ByteArrayOutputStream messageByteStream = new ByteArrayOutputStream();
             DataOutputStream messageDataStream = new DataOutputStream(messageByteStream);){
            messageDataStream.writeUTF(this.plugin.getGson().toJson(message));
            messageWriter.writeShort(messageByteStream.toByteArray().length);
            messageWriter.write(messageByteStream.toByteArray());
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "Exception dispatching plugin message", e);
            return;
        }
        sender.sendPluginMessage(messageWriter.toByteArray());
    }

    public void changeServer(@NotNull OnlineUser user, @NotNull String server) {
        user.dismount().thenRun(() -> {
            ByteArrayDataOutput outputStream = ByteStreams.newDataOutput();
            outputStream.writeUTF("Connect");
            outputStream.writeUTF(server);
            user.sendPluginMessage(outputStream.toByteArray());
        });
    }

    @Override
    public void close() {
    }
}

