/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.gson;

import java.io.IOException;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.gson.JsonElement;
import net.william278.huskhomes.libraries.gson.JsonParseException;
import net.william278.huskhomes.libraries.gson.stream.JsonReader;
import net.william278.huskhomes.libraries.gson.stream.JsonToken;

final class GsonHacks {
    private GsonHacks() {
    }

    static boolean isNullOrEmpty(@Nullable JsonElement element) {
        return element == null || element.isJsonNull() || element.isJsonArray() && element.getAsJsonArray().size() == 0 || element.isJsonObject() && element.getAsJsonObject().entrySet().isEmpty();
    }

    static boolean readBoolean(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.BOOLEAN) {
            return in.nextBoolean();
        }
        if (peek == JsonToken.STRING) {
            return Boolean.parseBoolean(in.nextString());
        }
        if (peek == JsonToken.NUMBER) {
            return in.nextString().equals("1");
        }
        throw new JsonParseException("Token of type " + (Object)((Object)peek) + " cannot be interpreted as a boolean");
    }

    static String readString(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.STRING || peek == JsonToken.NUMBER) {
            return in.nextString();
        }
        if (peek == JsonToken.BOOLEAN) {
            return String.valueOf(in.nextBoolean());
        }
        throw new JsonParseException("Token of type " + (Object)((Object)peek) + " cannot be interpreted as a string");
    }
}

