/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.util.ValidationException;

public class Validator {
    public static final int MAX_NAME_LENGTH = 16;
    public static final int MIN_NAME_LENGTH = 1;
    public static final int MAX_DESCRIPTION_LENGTH = 256;
    private final HuskHomes plugin;

    public Validator(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
    }

    public void validateName(@NotNull String name) throws ValidationException {
        if (!this.isValidNameCharacters(name)) {
            throw new ValidationException(ValidationException.Type.NAME_INVALID_CHARACTERS);
        }
        if (!this.isValidNameLength(name)) {
            throw new ValidationException(ValidationException.Type.NAME_INVALID_LENGTH);
        }
    }

    public void validateDescription(@NotNull String description) throws ValidationException {
        if (!this.isValidDescriptionCharacters(description)) {
            throw new ValidationException(ValidationException.Type.DESCRIPTION_INVALID_CHARACTERS);
        }
        if (!this.isValidDescriptionLength(description)) {
            throw new ValidationException(ValidationException.Type.DESCRIPTION_INVALID_LENGTH);
        }
    }

    private boolean isValidNameCharacters(@NotNull String name) {
        return (name.matches(this.plugin.getSettings().getNameRegex()) || !this.plugin.getSettings().doRestrictNames()) && !name.contains("\u0000") && !this.containsWhitespace(name) && !name.contains(".");
    }

    private boolean isValidNameLength(@NotNull String name) {
        return name.length() <= 16 && name.length() >= 1;
    }

    private boolean isValidDescriptionCharacters(@NotNull String description) {
        return (description.matches(this.plugin.getSettings().getDescriptionRegex()) || !this.plugin.getSettings().doRestrictDescriptions()) && !description.contains("\u0000");
    }

    private boolean isValidDescriptionLength(@NotNull String description) {
        return description.length() <= 256;
    }

    private boolean containsWhitespace(@NotNull String string) {
        return string.matches(".*\\s.*");
    }
}

