/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.EconomyHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.user.OnlineUser;

public interface TransactionResolver {
    default public boolean validateTransaction(@NotNull OnlineUser player, @NotNull Action action) {
        return this.hasFunds(player, action) && this.isNotOnCooldown(player, action);
    }

    private boolean hasFunds(@NotNull OnlineUser player, @NotNull Action action) {
        return this.getPlugin().getSettings().getEconomyCost(action).map(Math::abs).flatMap(c -> player.hasPermission("huskhomes.bypass_economy_checks") ? Optional.empty() : Optional.of(c)).map(c -> this.getEconomyHook().map(hook -> {
            if (hook.getPlayerBalance(player) < c) {
                this.getPlugin().getLocales().getLocale("error_insufficient_funds", hook.formatCurrency((double)c)).ifPresent(player::sendMessage);
                return false;
            }
            return true;
        }).orElse(true)).orElse(true);
    }

    private boolean isNotOnCooldown(@NotNull OnlineUser player, @NotNull Action action) {
        long configCooldown = this.getPlugin().getSettings().getCooldown(action);
        if (configCooldown <= 0L || player.hasPermission("huskhomes.bypass_cooldowns")) {
            return true;
        }
        return this.getPlugin().getDatabase().getCooldown(action, player).map(cooldownEnds -> {
            if (cooldownEnds.isAfter(Instant.now())) {
                this.getPlugin().getLocales().getLocale("error_on_cooldown", this.formatDuration(Duration.between(Instant.now(), cooldownEnds).abs())).ifPresent(player::sendMessage);
                return false;
            }
            this.getPlugin().getDatabase().removeCooldown(action, player);
            return true;
        }).orElse(true);
    }

    @NotNull
    private String formatDuration(@NotNull Duration duration) {
        long days = duration.toDays();
        long hours = duration.minusDays(days).toHours();
        long minutes = duration.minusDays(days).minusHours(hours).toMinutes();
        long seconds = duration.minusDays(days).minusHours(hours).minusMinutes(minutes).getSeconds();
        StringJoiner formattedDuration = new StringJoiner(" ");
        if (days > 0L) {
            formattedDuration.add(days + "d");
        }
        if (hours > 0L) {
            formattedDuration.add(hours + "h");
        }
        if (minutes > 0L) {
            formattedDuration.add(minutes + "m");
        }
        if (seconds > 0L) {
            formattedDuration.add(seconds + "s");
        }
        return formattedDuration.toString();
    }

    default public void performTransaction(@NotNull OnlineUser player, @NotNull Action action) {
        this.getEconomyHook().ifPresent(hook -> this.getPlugin().getSettings().getEconomyCost(action).map(Math::abs).flatMap(c -> player.hasPermission("huskhomes.bypass_economy_checks") ? Optional.empty() : Optional.of(c)).ifPresent(cost -> {
            hook.changePlayerBalance(player, -cost.doubleValue());
            hook.notifyDeducted(player, this.getPlugin(), action);
        }));
        long configCooldown = this.getPlugin().getSettings().getCooldown(action);
        if (configCooldown > 0L && !player.hasPermission("huskhomes.bypass_cooldowns")) {
            this.getPlugin().getDatabase().setCooldown(action, player, Instant.now().plusSeconds(configCooldown));
        }
    }

    @Deprecated(since="4.4", forRemoval=true)
    default public void performTransaction(@NotNull OnlineUser player, @NotNull EconomyHook.Action action) {
        this.performTransaction(player, action.getTransactionAction());
    }

    @Deprecated(since="4.4", forRemoval=true)
    default public boolean canPerformTransaction(@NotNull OnlineUser player, @NotNull EconomyHook.Action action) {
        return this.validateTransaction(player, action.getTransactionAction());
    }

    @NotNull
    default public Optional<EconomyHook> getEconomyHook() {
        return this.getPlugin().getHook(EconomyHook.class);
    }

    @NotNull
    public HuskHomes getPlugin();

    public static enum Action {
        ADDITIONAL_HOME_SLOT(100.0, 0),
        MAKE_HOME_PUBLIC(50.0, 0),
        BACK_COMMAND,
        RANDOM_TELEPORT(25.0, 600),
        HOME_TELEPORT,
        PUBLIC_HOME_TELEPORT,
        WARP_TELEPORT,
        SPAWN_TELEPORT,
        SEND_TELEPORT_REQUEST,
        ACCEPT_TELEPORT_REQUEST;

        public static final String BYPASS_ECONOMY_PERMISSION = "huskhomes.bypass_economy_checks";
        public static final String BYPASS_COOLDOWNS_PERMISSION = "huskhomes.bypass_cooldowns";
        private final double defaultCost;
        private final int defaultCooldown;

        private Action(double defaultCost, int defaultCooldown) {
            this.defaultCost = defaultCost;
            this.defaultCooldown = defaultCooldown;
        }

        private Action() {
            this(0.0, 0);
        }

        public double getDefaultCost() {
            return this.defaultCost;
        }

        public int getDefaultCooldown() {
            return this.defaultCooldown;
        }

        @NotNull
        public static Map<String, Double> getEconomyCostsConfigMap() {
            return Arrays.stream(Action.values()).filter(action -> action.getDefaultCost() > 0.0).collect(Collectors.toMap(action -> action.name().toLowerCase(Locale.ENGLISH), Action::getDefaultCost));
        }

        @NotNull
        public static Map<String, Integer> getCooldownsConfigMap() {
            return Arrays.stream(Action.values()).filter(action -> action.getDefaultCooldown() > 0).collect(Collectors.toMap(action -> action.name().toLowerCase(Locale.ENGLISH), Action::getDefaultCooldown));
        }
    }
}

