/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.paperlib.scheduling.GracefulScheduling;
import net.william278.huskhomes.libraries.paperlib.scheduling.ScheduledTask;
import net.william278.huskhomes.util.Task;

public interface BukkitTask
extends Task {
    default public boolean isPluginDisabled() {
        return !((BukkitHuskHomes)this.getPlugin()).isEnabled();
    }

    @NotNull
    default public GracefulScheduling getScheduler() {
        return ((BukkitHuskHomes)this.getPlugin()).getScheduler();
    }

    public static interface Supplier
    extends Task.Supplier {
        @Override
        @NotNull
        default public Task.Sync getSyncTask(@NotNull Runnable runnable, long delayTicks) {
            return new Sync(this.getPlugin(), runnable, delayTicks);
        }

        @Override
        @NotNull
        default public Task.Async getAsyncTask(@NotNull Runnable runnable) {
            return new Async(this.getPlugin(), runnable);
        }

        @Override
        @NotNull
        default public Task.Repeating getRepeatingTask(@NotNull Runnable runnable, long repeatingTicks) {
            return new Repeating(this.getPlugin(), runnable, repeatingTicks);
        }

        @Override
        default public void cancelTasks() {
            ((BukkitHuskHomes)this.getPlugin()).getScheduler().cancelGlobalTasks();
        }
    }

    public static class Repeating
    extends Task.Repeating
    implements BukkitTask {
        private ScheduledTask task;

        protected Repeating(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long repeatingTicks) {
            super(plugin, runnable, repeatingTicks);
        }

        @Override
        public void cancel() {
            if (this.task != null && !this.cancelled) {
                this.task.cancel();
            }
            super.cancel();
        }

        @Override
        public void run() {
            if (this.isPluginDisabled()) {
                return;
            }
            if (!this.cancelled) {
                this.task = this.getScheduler().asyncScheduler().runAtFixedRate(this.runnable, Duration.ZERO, Duration.of(this.repeatingTicks * 50L, ChronoUnit.MILLIS));
            }
        }
    }

    public static class Async
    extends Task.Async
    implements BukkitTask {
        private ScheduledTask task;

        protected Async(@NotNull HuskHomes plugin, @NotNull Runnable runnable) {
            super(plugin, runnable);
        }

        @Override
        public void cancel() {
            if (this.task != null && !this.cancelled) {
                this.task.cancel();
            }
            super.cancel();
        }

        @Override
        public void run() {
            if (this.isPluginDisabled()) {
                this.runnable.run();
                return;
            }
            if (!this.cancelled) {
                this.task = this.getScheduler().asyncScheduler().run(this.runnable);
            }
        }
    }

    public static class Sync
    extends Task.Sync
    implements BukkitTask {
        private ScheduledTask task;

        protected Sync(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long delayTicks) {
            super(plugin, runnable, delayTicks);
        }

        @Override
        public void cancel() {
            if (this.task != null && !this.cancelled) {
                this.task.cancel();
            }
            super.cancel();
        }

        @Override
        public void run() {
            if (this.isPluginDisabled()) {
                this.runnable.run();
                return;
            }
            this.task = this.delayTicks > 0L ? this.getScheduler().globalRegionalScheduler().runDelayed(this.runnable, this.delayTicks) : this.getScheduler().globalRegionalScheduler().run(this.runnable);
        }
    }
}

