/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.paperlib.PaperLib;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.util.BukkitAdapter;
import net.william278.huskhomes.util.SafetyResolver;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;

public interface BukkitSafetyResolver
extends SafetyResolver {
    @Override
    default public CompletableFuture<Optional<Location>> findSafeGroundLocation(@NotNull Location location) {
        org.bukkit.Location bukkitLocation = BukkitAdapter.adaptLocation(location).orElse(null);
        if (bukkitLocation == null || bukkitLocation.getWorld() == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (!bukkitLocation.getWorld().getWorldBorder().isInside(bukkitLocation)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return ((CompletableFuture)PaperLib.getChunkAtAsync(bukkitLocation).thenApply(Chunk::getChunkSnapshot)).thenApply(snapshot -> this.findSafeLocationNear(location, (ChunkSnapshot)snapshot, bukkitLocation.getWorld().getMinHeight()));
    }

    private Optional<Location> findSafeLocationNear(@NotNull Location location, @NotNull ChunkSnapshot chunk, int minY) {
        int chunkX = (int)location.getX() & 0xF;
        int chunkZ = (int)location.getZ() & 0xF;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                int x = chunkX + dx;
                int z = chunkZ + dz;
                if (x < 0 || x >= 16 || z < 0 || z >= 16) continue;
                int y = Math.max(minY + 1, chunk.getHighestBlockYAt(x, z)) + 1;
                Material blockType = chunk.getBlockType(x, y - 1, z);
                Material bodyBlockType = chunk.getBlockType(x, y, z);
                Material headBlockType = chunk.getBlockType(x, y + 1, z);
                if (!this.isBlockSafeForStanding(blockType.getKey().toString()) || !this.isBlockSafeForOccupation(bodyBlockType.getKey().toString()) || !this.isBlockSafeForOccupation(headBlockType.getKey().toString())) continue;
                double locx = Math.floor(location.getX()) + (double)dx;
                locx = locx < 0.0 ? (locx += 1.5) : (locx += 0.5);
                double locz = Math.floor(location.getZ()) + (double)dz;
                locz = locz < 0.0 ? (locz += 1.5) : (locz += 0.5);
                return Optional.of(Location.at(locx, y, locz, location.getWorld()));
            }
        }
        return Optional.empty();
    }
}

