/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.util.Optional;
import java.util.UUID;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.World;
import org.bukkit.Bukkit;
import org.bukkit.World;

public final class BukkitAdapter {
    public static Optional<org.bukkit.Location> adaptLocation(@NotNull Location location) {
        World world = Bukkit.getWorld((String)location.getWorld().getName());
        if (world == null) {
            world = Bukkit.getWorld((UUID)location.getWorld().getUuid());
        }
        if (world == null) {
            world = Bukkit.getWorlds().stream().filter(w -> w.getEnvironment().name().equalsIgnoreCase(location.getWorld().getEnvironment().name())).findFirst().orElse(null);
        }
        if (world == null) {
            return Optional.empty();
        }
        return Optional.of(new org.bukkit.Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch()));
    }

    public static Optional<Location> adaptLocation(@NotNull org.bukkit.Location location) {
        if (location.getWorld() == null) {
            return Optional.empty();
        }
        return Optional.of(Location.at(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), BukkitAdapter.adaptWorld(location.getWorld()).orElse(new net.william278.huskhomes.position.World())));
    }

    public static Optional<net.william278.huskhomes.position.World> adaptWorld(@Nullable World world) {
        if (world == null) {
            return Optional.empty();
        }
        String string = world.getName();
        UUID uUID = world.getUID();
        return Optional.of(net.william278.huskhomes.position.World.from(string, uUID, switch (world.getEnvironment()) {
            case World.Environment.NORMAL -> World.Environment.OVERWORLD;
            case World.Environment.NETHER -> World.Environment.NETHER;
            case World.Environment.THE_END -> World.Environment.THE_END;
            default -> World.Environment.CUSTOM;
        }));
    }
}

