/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.user;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.libraries.adventure.audience.Audience;
import net.william278.huskhomes.libraries.adventure.key.InvalidKeyException;
import net.william278.huskhomes.libraries.adventure.key.Key;
import net.william278.huskhomes.libraries.adventure.sound.Sound;
import net.william278.huskhomes.libraries.adventure.text.Component;
import net.william278.huskhomes.libraries.adventure.title.Title;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.lang.annotations.Subst;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.libraries.minedown.adventure.MineDownParser;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.User;

public abstract class OnlineUser
extends User
implements Teleportable,
CommandUser {
    public OnlineUser(@NotNull UUID uuid, @NotNull String username) {
        super(uuid, username);
    }

    public abstract Position getPosition();

    public abstract Optional<Position> getBedSpawnPosition();

    public abstract double getHealth();

    @Override
    public abstract boolean hasPermission(@NotNull String var1);

    @NotNull
    public abstract Map<String, Boolean> getPermissions();

    public void sendTitle(@NotNull MineDown mineDown, boolean subTitle) {
        Component message = mineDown.disable(MineDownParser.Option.SIMPLE_FORMATTING).replace(new String[0]).toComponent();
        this.getAudience().showTitle(Title.title(subTitle ? Component.empty() : message, subTitle ? message : Component.empty()));
    }

    public void sendActionBar(@NotNull MineDown mineDown) {
        this.getAudience().sendActionBar(mineDown.disable(MineDownParser.Option.SIMPLE_FORMATTING).replace(new String[0]).toComponent());
    }

    @Override
    public void sendMessage(@NotNull MineDown mineDown) {
        this.getAudience().sendMessage(mineDown.disable(MineDownParser.Option.SIMPLE_FORMATTING).replace(new String[0]).toComponent());
    }

    public void sendMessage(@NotNull MineDown mineDown, @NotNull Locales.DisplaySlot slot) {
        if (slot == Locales.DisplaySlot.CHAT) {
            this.sendMessage(mineDown);
        } else if (slot == Locales.DisplaySlot.ACTION_BAR) {
            this.sendActionBar(mineDown);
        } else if (slot == Locales.DisplaySlot.TITLE) {
            this.sendTitle(mineDown, false);
        } else if (slot == Locales.DisplaySlot.SUBTITLE) {
            this.sendTitle(mineDown, true);
        }
    }

    public void sendTranslatableMessage(@Subst(value="minecraftblock.minecraft.spawn.not_valid") @NotNull String translationKey) {
        this.getAudience().sendMessage(Component.translatable(translationKey));
    }

    public void playSound(@Subst(value="minecraft:block.note_block.banjo") @NotNull String soundEffect) throws IllegalArgumentException {
        try {
            this.getAudience().playSound(Sound.sound(Key.key(soundEffect), Sound.Source.PLAYER, 1.0f, 1.0f), Sound.Emitter.self());
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid sound effect name: " + soundEffect);
        }
    }

    @Override
    @NotNull
    public abstract Audience getAudience();

    public abstract void teleportLocally(@NotNull Location var1, boolean var2) throws TeleportationException;

    public abstract void sendPluginMessage(@NotNull String var1, byte[] var2);

    public abstract boolean isMoving();

    public abstract boolean isVanished();

    public final int getMaxHomes(int defaultMaxHomes, boolean stack) {
        List<Integer> homes = this.getNumericalPermissions("huskhomes.max_homes.");
        if (homes.isEmpty()) {
            return defaultMaxHomes;
        }
        if (stack) {
            return defaultMaxHomes + homes.stream().reduce(0, Integer::sum);
        }
        return homes.get(0);
    }

    public int getMaxPublicHomes(int defaultPublicHomes, boolean stack) {
        List<Integer> homes = this.getNumericalPermissions("huskhomes.max_public_homes.");
        if (homes.isEmpty()) {
            return defaultPublicHomes;
        }
        if (stack) {
            return defaultPublicHomes + homes.stream().reduce(0, Integer::sum);
        }
        return homes.get(0);
    }

    public int getFreeHomes(int defaultFreeHomes, boolean stack) {
        List<Integer> homes = this.getNumericalPermissions("huskhomes.free_homes.");
        if (homes.isEmpty()) {
            return defaultFreeHomes;
        }
        if (stack) {
            return defaultFreeHomes + homes.stream().reduce(0, Integer::sum);
        }
        return homes.get(0);
    }

    @NotNull
    protected List<Integer> getNumericalPermissions(@NotNull String nodePrefix) {
        return this.getPermissions().entrySet().stream().filter(Map.Entry::getValue).filter(permission -> ((String)permission.getKey()).startsWith(nodePrefix)).filter(permission -> {
            try {
                Integer.parseInt(((String)permission.getKey()).substring(nodePrefix.length()));
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }).map(permission -> Integer.parseInt(((String)permission.getKey()).substring(nodePrefix.length()))).sorted(Collections.reverseOrder()).toList();
    }
}

