/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.user;

import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.libraries.adventure.audience.Audience;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.paperlib.PaperLib;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.BukkitAdapter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class BukkitUser
extends OnlineUser {
    private final BukkitHuskHomes plugin;
    private final Player player;

    private BukkitUser(@NotNull Player player, @NotNull BukkitHuskHomes plugin) {
        super(player.getUniqueId(), player.getName());
        this.player = player;
        this.plugin = plugin;
    }

    @NotNull
    public static BukkitUser adapt(@NotNull Player player, @NotNull BukkitHuskHomes plugin) {
        return new BukkitUser(player, plugin);
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Position getPosition() {
        return Position.at(BukkitAdapter.adaptLocation(this.player.getLocation()).orElseThrow(() -> new IllegalStateException("Failed to get the position of a BukkitPlayer (null)")), this.plugin.getServerName());
    }

    @Override
    public Optional<Position> getBedSpawnPosition() {
        return Optional.ofNullable(this.player.getBedSpawnLocation()).flatMap(BukkitAdapter::adaptLocation).map(location -> Position.at(location, this.plugin.getServerName()));
    }

    @Override
    public double getHealth() {
        return this.player.getHealth();
    }

    @Override
    public boolean hasPermission(@NotNull String node) {
        return this.player.hasPermission(node);
    }

    @Override
    @NotNull
    public Map<String, Boolean> getPermissions() {
        return this.player.getEffectivePermissions().stream().collect(Collectors.toMap(PermissionAttachmentInfo::getPermission, PermissionAttachmentInfo::getValue, (a, b) -> b));
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return this.plugin.getAudiences().player(this.player);
    }

    @Override
    public void teleportLocally(@NotNull Location location, boolean async) throws TeleportationException {
        Optional<org.bukkit.Location> resolvedLocation = BukkitAdapter.adaptLocation(location);
        if (resolvedLocation.isEmpty() || resolvedLocation.get().getWorld() == null) {
            throw new TeleportationException(TeleportationException.Type.WORLD_NOT_FOUND, this.plugin);
        }
        org.bukkit.Location bukkitLocation = resolvedLocation.get();
        if (!bukkitLocation.getWorld().getWorldBorder().isInside(resolvedLocation.get())) {
            throw new TeleportationException(TeleportationException.Type.ILLEGAL_TARGET_COORDINATES, this.plugin);
        }
        this.plugin.getScheduler().entitySpecificScheduler((Entity)this.player).run(() -> {
            this.player.leaveVehicle();
            this.player.eject();
            if (async || this.plugin.getScheduler().isUsingFolia()) {
                PaperLib.teleportAsync((Entity)this.player, bukkitLocation, PlayerTeleportEvent.TeleportCause.PLUGIN);
                return;
            }
            this.player.teleport(bukkitLocation, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }, () -> this.plugin.log(Level.WARNING, "User offline when teleporting: " + this.player.getName(), new Throwable[0]));
    }

    @Override
    public boolean isMoving() {
        return this.player.getVelocity().length() >= 0.1;
    }

    @Override
    public boolean isVanished() {
        return this.player.getMetadata("vanished").stream().map(MetadataValue::asBoolean).findFirst().orElse(false);
    }

    @Override
    public void sendPluginMessage(@NotNull String channel, byte[] message) {
        this.player.sendPluginMessage((Plugin)this.plugin, channel, message);
    }
}

