/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.teleport;

import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.user.CommandUser;

public class TeleportationException
extends IllegalStateException {
    private final HuskHomes plugin;
    private final Type type;

    public TeleportationException(@NotNull Type cause, @NotNull HuskHomes plugin) {
        super("Error executing teleport: " + cause.name());
        this.type = cause;
        this.plugin = plugin;
    }

    public void displayMessage(@NotNull CommandUser user, String ... args) {
        switch (this.type) {
            case TELEPORTER_NOT_FOUND: 
            case TARGET_NOT_FOUND: {
                this.plugin.getLocales().getLocale("error_player_not_found", args).ifPresent(user::sendMessage);
                break;
            }
            case ALREADY_WARMING_UP: {
                this.plugin.getLocales().getLocale("error_already_teleporting").ifPresent(user::sendMessage);
                break;
            }
            case WARMUP_ALREADY_MOVING: {
                this.plugin.getLocales().getLocale("error_teleport_warmup_stand_still").ifPresent(user::sendMessage);
                break;
            }
            case CANNOT_TELEPORT_TO_SELF: {
                this.plugin.getLocales().getLocale("error_teleport_request_self").ifPresent(user::sendMessage);
                break;
            }
            case ILLEGAL_TARGET_COORDINATES: {
                this.plugin.getLocales().getLocale("error_illegal_target_coordinates").ifPresent(user::sendMessage);
                break;
            }
            case WORLD_NOT_FOUND: {
                this.plugin.getLocales().getLocale("error_invalid_world").ifPresent(user::sendMessage);
                break;
            }
        }
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public static enum Type {
        TELEPORTER_NOT_FOUND,
        TARGET_NOT_FOUND,
        ALREADY_WARMING_UP,
        TRANSACTION_FAILED,
        WARMUP_ALREADY_MOVING,
        WORLD_NOT_FOUND,
        ILLEGAL_TARGET_COORDINATES,
        CANNOT_TELEPORT_TO_SELF;

    }
}

