/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.teleport;

import java.time.Instant;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.gson.annotations.Expose;
import net.william278.huskhomes.libraries.gson.annotations.SerializedName;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.user.OnlineUser;

public class TeleportRequest {
    @Expose
    @SerializedName(value="requester_name")
    private String requesterName;
    @Expose
    @SerializedName(value="requester_position")
    private Position requesterPosition;
    @Expose
    @SerializedName(value="expiry_time")
    private long expiryTime;
    @Expose
    private Type type;
    @Expose
    private Status status;
    @Expose
    @SerializedName(value="recipient_name")
    private String recipientName;

    public TeleportRequest(@NotNull OnlineUser requester, @NotNull Type type, long expiryTime) {
        this.setRequesterName(requester.getUsername());
        this.setRequesterPosition(requester.getPosition());
        this.setType(type);
        this.setStatus(Status.PENDING);
        this.expiryTime = expiryTime;
    }

    private TeleportRequest() {
    }

    public boolean hasExpired() {
        return Instant.now().isAfter(Instant.ofEpochSecond(this.expiryTime));
    }

    @NotNull
    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(@NotNull String recipientName) {
        this.recipientName = recipientName;
    }

    @NotNull
    public String getRequesterName() {
        return this.requesterName;
    }

    public void setRequesterName(String requesterName) {
        this.requesterName = requesterName;
    }

    @NotNull
    public Position getRequesterPosition() {
        return this.requesterPosition;
    }

    public void setRequesterPosition(Position requesterPosition) {
        this.requesterPosition = requesterPosition;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public void setType(@NotNull Type type) {
        this.type = type;
    }

    @NotNull
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull Status status) {
        this.status = status;
    }

    public static enum Type {
        TPA,
        TPA_HERE;

    }

    public static enum Status {
        PENDING,
        ACCEPTED,
        DECLINED,
        IGNORED;

    }
}

